/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.p2pd.util.ServletUtils;
import com.cognos.p2plb.clerver.Pinger;
import com.cognos.p2plb.model.Node;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeView;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.p2plb.util.Action;
import com.cognos.p2plb.util.ActionQueue;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class NodeHospital {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(NodeHospital.class.getName());
    static final Logger ttcat = Hierarchy.getDefaultHierarchy().getLoggerFor(DoTheRounds.class.getName());
    ArrayList<Node> sick_nodes = new ArrayList();
    ActionQueue ping_queue;
    Pinger pinger = new Pinger();
    DoTheRounds do_the_rounds = new DoTheRounds();
    NodeViewPool the_pool;
    Timer timer;
    Random random = new Random();
    int check_interval_ms = 1;
    int min_interval_ticks = 10;
    int max_interval_ticks = 10;
    int slope_mult = 1;
    int slope_div = 1;

    public NodeHospital(ActionQueue action_queue, Timer timer) {
        this.ping_queue = action_queue;
        this.timer = timer;
    }

    public void setThePool(NodeViewPool nvp) {
        this.the_pool = nvp;
    }

    public void init(Element config) {
        Element eNH = config.element("nodeHospital");
        if (eNH == null) {
            cat.error("nodeHospital configuration is missing, will use hard coded defaults.");
        } else {
            try {
                this.check_interval_ms = Integer.parseInt(eNH.elementText("nh_check_interval_ms"));
                this.min_interval_ticks = Integer.parseInt(eNH.elementText("nh_min_interval_ticks"));
                this.max_interval_ticks = Integer.parseInt(eNH.elementText("nh_max_interval_ticks"));
                this.slope_mult = Integer.parseInt(eNH.elementText("nh_slope_mult"));
                this.slope_div = Integer.parseInt(eNH.elementText("nh_slope_div"));
            }
            catch (Exception x) {
                cat.error("Invalid or missing NodeHospital parameter value.");
            }
        }
    }

    public void init(Map<?, ?> initparms) {
        this.check_interval_ms = ServletUtils.getParmInt(initparms, "nh_check_interval_ms", 1000);
        this.min_interval_ticks = ServletUtils.getParmInt(initparms, "nh_min_interval_ticks", 5);
        this.max_interval_ticks = ServletUtils.getParmInt(initparms, "nh_max_interval_ticks", 300);
        this.slope_mult = ServletUtils.getParmInt(initparms, "nh_slope_mult", 2);
        this.slope_div = ServletUtils.getParmInt(initparms, "nh_slope_div", 1);
    }

    public void start() {
        this.timer.schedule((TimerTask)this.do_the_rounds, this.check_interval_ms, (long)this.check_interval_ms);
    }

    public void stop() {
        this.do_the_rounds.cancel();
    }

    public boolean isAdmitted(NodeID nid) {
        Iterator<Node> it = this.sick_nodes.iterator();
        while (it.hasNext()) {
            if (!((SickNode)it.next()).node_view.getNodeID().isTheSameAs(nid)) continue;
            return true;
        }
        return false;
    }

    SickNode find(NodeID nid) {
        for (SickNode sickNode : this.sick_nodes) {
            if (!sickNode.node_view.getNodeID().isTheSameAs(nid)) continue;
            return sickNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void admit(NodeView nv) {
        ArrayList<Node> arrayList = this.sick_nodes;
        synchronized (arrayList) {
            if (nv.getState() != 2) {
                cat.debug("Huh? Try to admit node that is not down! " + nv.getNodeID().toString());
                return;
            }
            if (this.isAdmitted(nv.getNodeID())) {
                cat.debug("Huh? Try to admit node that is already admitted! " + nv.getNodeID().toString());
                return;
            }
            SickNode sn = new SickNode(nv, this.min_interval_ticks);
            sn.randomizeMarkLimit(this.random);
            this.sick_nodes.add(sn);
        }
        cat.info("Node admitted to hospital: " + nv.getNodeID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNodeUnavailable(NodeView nv) {
        ArrayList<Node> arrayList = this.sick_nodes;
        synchronized (arrayList) {
            SickNode sn;
            if (nv.getState() != 2) {
                cat.debug("Huh? Try to mark a node that is not down unavailable! " + nv.getNodeID().toString());
                nv.setState(2);
            }
            if ((sn = this.find(nv.getNodeID())) != null) {
                this.sick_nodes.remove(sn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discharge(SickNode sn) {
        ArrayList<Node> arrayList = this.sick_nodes;
        synchronized (arrayList) {
            if (!this.sick_nodes.remove(sn)) {
                cat.debug("Huh? Tried to discharge node that is not in the hospital: " + sn.node_view.getNodeID().toString());
            }
        }
        cat.info("Node discharged: " + sn.node_view.getNodeID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discharge(NodeView nv) {
        ArrayList<Node> arrayList = this.sick_nodes;
        synchronized (arrayList) {
            this.sick_nodes.remove(nv);
        }
        cat.info("Node discharged: " + nv.getNodeID().toString());
    }

    public void configure(Configuration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Configuration configuration) {
        ArrayList<Node> arrayList = this.sick_nodes;
        synchronized (arrayList) {
            if (this.sick_nodes.size() == 0) {
                return;
            }
        }
        HashSet<String> guidSet = new HashSet<String>();
        DispatcherList dispList = (DispatcherList)configuration.getDispatcherList();
        Iterator<DispatcherListElement> iter = dispList.getAllDispatcherListElements();
        while (iter.hasNext()) {
            DispatcherListElement dle = iter.next();
            guidSet.add(dle.getGuid());
        }
        ArrayList<Node> arrayList2 = this.sick_nodes;
        synchronized (arrayList2) {
            ListIterator<Node> it = this.sick_nodes.listIterator();
            while (it.hasNext()) {
                SickNode sn = (SickNode)it.next();
                String guid = sn.node_view.nodeid.getGuid();
                if (guidSet.contains(guid)) continue;
                if (cat.isDebugEnabled()) {
                    cat.debug("Node in the hospital no longer exists in CM, it was probably unregistered.  Removing it from the hospital. " + sn.node_view.nodeid.toString());
                }
                sn.retire();
                it.remove();
                sn.node_view.setState(1);
            }
        }
    }

    class DoTheRounds
    extends SafeTimerTask {
        DoTheRounds() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void safeRun() {
            ArrayList<Node> arrayList = NodeHospital.this.sick_nodes;
            synchronized (arrayList) {
                for (SickNode sickNode : NodeHospital.this.sick_nodes) {
                    if (sickNode.isQueued() || ++sickNode.mark_count < sickNode.mark_limit) continue;
                    NodeHospital.this.ping_queue.enqueue(sickNode);
                    sickNode.mark_count = -1;
                }
            }
        }
    }

    class SickNode
    extends Action
    implements Node {
        NodeView node_view;
        int mark_count = 0;
        int mark_limit;
        int interval;
        private boolean retired = false;
        String lastError;

        boolean isRetired() {
            return this.retired;
        }

        void retire() {
            this.retired = true;
        }

        SickNode(NodeView node_view, int interval) {
            this.node_view = node_view;
            this.interval = interval;
        }

        void calcMarkLimit() {
            this.mark_limit = this.interval;
        }

        void randomizeMarkLimit(Random random) {
            this.mark_count = random.nextInt(this.mark_limit + 1);
        }

        public boolean equals(Object o) {
            if (o instanceof NodeView) {
                return this.node_view.equals(o);
            }
            return this == o;
        }

        public int hashCode() {
            return this.node_view.hashCode();
        }

        @Override
        public void run() {
            if (this.isRetired()) {
                cat.debug("node was retired, don't check it.");
                return;
            }
            cat.debug("checking: " + this.node_view.getNodeID().toString());
            if (NodeHospital.this.pinger.ping(this.node_view, null)) {
                String pingResult = NodeHospital.this.pinger.getPingResult();
                if ("ok".equals(pingResult)) {
                    if (!this.isRetired()) {
                        NodeHospital.this.discharge(this);
                        this.node_view.setState(1);
                    }
                } else {
                    if (cat.isDebugEnabled()) {
                        cat.debug("pinged a node successfully, but it reported a non-ok result: " + NodeHospital.this.pinger.getPingResult());
                    }
                    if ("notReady".equals(pingResult)) {
                        this.reportError("notReady");
                        this.calcMarkLimit();
                        this.mark_count = 0;
                        return;
                    }
                }
            } else {
                String errcode = NodeHospital.this.pinger.getErrorCode();
                this.reportError(errcode);
                if (this.interval < NodeHospital.this.max_interval_ticks) {
                    this.interval *= NodeHospital.this.slope_mult;
                    this.interval /= NodeHospital.this.slope_div;
                    if (this.interval > NodeHospital.this.max_interval_ticks) {
                        this.interval = NodeHospital.this.max_interval_ticks;
                    }
                }
                this.calcMarkLimit();
                this.mark_count = 0;
            }
        }

        void reportError(String errorCode) {
            if (cat.isErrorEnabled() && errorCode != null && !errorCode.equals(this.lastError)) {
                cat.error("Ping of sick dispatcher " + this.node_view.getNodeID().toString() + " failed.  Error code = " + errorCode);
            }
            this.lastError = errorCode;
        }
    }
}

