/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.model;

import com.cognos.p2plb.core.MessageTimes;

public class NodeTime {
    protected long clock_offset = 0L;
    protected long delay = 0L;

    public NodeTime() {
    }

    public NodeTime(MessageTimes message_times) {
        this.set(message_times);
    }

    public void set(MessageTimes message_times) {
        this.clock_offset = message_times.getClockOffset();
        this.delay = message_times.getDelay();
    }

    public void assign(NodeTime node_time) {
        this.clock_offset = node_time.clock_offset;
        this.delay = node_time.delay;
    }

    public boolean isBogus() {
        return this.clock_offset == 0L && this.delay == 0L;
    }

    public NodeTime(long clock_offset, long delay) {
        this.clock_offset = clock_offset;
        this.delay = delay;
    }

    public long getClockOffset() {
        return this.clock_offset;
    }

    public void setClockOffset(long clock_offset) {
        this.clock_offset = clock_offset;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.clock_offset).append(";").append(this.delay);
        return sb.toString();
    }

    public void fromString(String s) {
        this.clock_offset = 0L;
        this.delay = 0L;
        if (s == null) {
            return;
        }
        int ipos = s.indexOf(59);
        if (ipos == -1) {
            return;
        }
        this.clock_offset = Long.parseLong(s.substring(0, ipos));
        this.delay = Long.parseLong(s.substring(ipos + 1));
    }

    public void flipPerspective() {
        this.clock_offset = -this.clock_offset;
    }
}

