/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.strategy.wt_round_robin;

import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.strategy.wt_round_robin.Candidate;
import com.cognos.pogo.util.PogoLogger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CandidateList {
    static final PogoLogger log = PogoLogger.getLogger();
    static final Logger cat_detail = Hierarchy.getDefaultHierarchy().getLoggerFor(CandidateList.class.getName() + ".DETAIL");
    public static final int NOT_FOUND = -1;
    int icirc = 0;
    int history_length = 20;
    int count = 0;
    Candidate[] history;
    private boolean can_balance;
    private boolean balanceToSelf;
    private boolean isAvailableLocally = false;
    private double inProgressRequestFactor = 0.0;
    private ArrayList<Candidate> list;

    public synchronized void setInProgressRequestFactor(double inProgFactor) {
        this.inProgressRequestFactor = inProgFactor;
    }

    public synchronized double getInProgressRequestFactor() {
        return this.inProgressRequestFactor;
    }

    public CandidateList(int history_length) {
        this.history = new Candidate[history_length];
        this.list = new ArrayList(history_length);
    }

    public void prepare() {
        this.normalizeWeights();
        this.calculateOneMaxWeights();
        this.icirc = 0;
        this.count = 0;
        this.testCanBalance();
        this.testIsAvailableLocally();
    }

    void normalizeWeights() {
        int i;
        double total_weight = 0.0;
        for (i = 0; i < this.size(); ++i) {
            total_weight += this.get(i).getConfiguredWeight();
        }
        for (i = 0; i < this.size(); ++i) {
            Candidate c = this.get(i);
            c.setNormalizedWeight(total_weight > 0.0 ? c.getConfiguredWeight() / total_weight : 0.0);
        }
    }

    void calculateOneMaxWeights() {
        int i;
        double max_weight = 0.0;
        for (i = 0; i < this.size(); ++i) {
            double weight = this.get(i).getConfiguredWeight();
            max_weight = Math.max(max_weight, weight);
        }
        if (max_weight == 0.0) {
            max_weight = 1.0;
        }
        for (i = 0; i < this.size(); ++i) {
            Candidate c = this.get(i);
            c.setOneMaxWeight(c.getConfiguredWeight() / max_weight);
        }
    }

    private void testIsAvailableLocally() {
        this.isAvailableLocally = false;
        for (int i = 0; i < this.size(); ++i) {
            Candidate c = this.get(i);
            ClusterNodeView cnv = this.getClusterNodeView(c);
            if (!cnv.getNodeID().isTheSameAs(NodeID.getSelf())) continue;
            this.isAvailableLocally = true;
            return;
        }
    }

    private ClusterNodeView getClusterNodeView(Candidate c) {
        return (ClusterNodeView)c.getObject();
    }

    private void testCanBalance() {
        this.balanceToSelf = false;
        if (this.size() > 1) {
            this.can_balance = true;
            return;
        }
        if (this.size() == 0) {
            this.can_balance = false;
            return;
        }
        this.can_balance = true;
        Candidate c = this.get(0);
        ClusterNodeView cnv = this.getClusterNodeView(c);
        if (cnv.getNodeID().isTheSameAs(NodeID.getSelf())) {
            this.balanceToSelf = true;
        }
    }

    public boolean balanceToSelfOnly() {
        return this.balanceToSelf;
    }

    public Object remove(ClusterNodeView cnv) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getObject() != cnv) continue;
            return this.list.remove(i);
        }
        return null;
    }

    private int getInProgressRequestCount(Candidate c) {
        return this.getClusterNodeView(c).getNodeView().getInProgressRequestCount();
    }

    public Candidate getBest() {
        return this.getBest(null);
    }

    public Candidate getBest(HashSet<Candidate> visited) {
        if (!this.can_balance) {
            log.debug("no nodes to balance to.");
            return null;
        }
        if (this.balanceToSelf) {
            log.debug("trivial cluster contains only self node, so chose it.");
            Candidate selfnode = this.get(0);
            if (visited != null && visited.contains(selfnode)) {
                log.debug("self node has been visited, return null.");
                return null;
            }
            return selfnode;
        }
        if (visited != null && visited.size() >= this.list.size()) {
            log.debug("All nodes have been visited");
            return null;
        }
        ArrayList<Candidate> unvisitedList = this.removeVisited(visited);
        return unvisitedList.isEmpty() ? null : this.getBestFromList(unvisitedList);
    }

    private ArrayList<Candidate> removeVisited(HashSet<Candidate> visited) {
        return visited == null || visited.isEmpty() ? this.list : this.removeVisitedFromList(visited);
    }

    private ArrayList<Candidate> removeVisitedFromList(HashSet<Candidate> visited) {
        ArrayList<Candidate> unvisitedList = new ArrayList<Candidate>();
        for (Candidate candidate : this.list) {
            if (visited.contains(candidate)) continue;
            unvisitedList.add(candidate);
        }
        return unvisitedList;
    }

    private Candidate getBestFromList(ArrayList<Candidate> unvisitedList) {
        ++this.icirc;
        this.icirc %= this.history_length;
        Candidate old = this.history[this.icirc];
        if (old != null) {
            old.decrementTimesUsed();
        }
        ++this.count;
        this.count = Math.min(this.count, this.history_length);
        double[] errors = new double[unvisitedList.size()];
        double total_error = 0.0;
        for (int i = 0; i < unvisitedList.size(); ++i) {
            errors[i] = unvisitedList.get(i).getError(this.count);
            total_error += errors[i];
        }
        double smallest_error = Double.MAX_VALUE;
        Candidate best = null;
        int ibest = -1;
        for (int i = 0; i < unvisitedList.size(); ++i) {
            double old_error = errors[i];
            total_error -= old_error;
            Candidate c = unvisitedList.get(i);
            c.incrementTimesUsed();
            double new_error = c.getError(this.count);
            double inProgressError = 0.0;
            double factor = this.getInProgressRequestFactor();
            if (factor > 0.0) {
                inProgressError = (double)this.getInProgressRequestCount(c) / c.getOneMaxWeight();
                inProgressError *= inProgressError;
                new_error += (inProgressError *= factor);
            }
            total_error += new_error;
            if (cat_detail.isDebugEnabled()) {
                this.debugCurrentError(i, total_error, old_error, new_error, inProgressError, unvisitedList, errors);
            }
            if (total_error < smallest_error && c.getConfiguredWeight() > 0.0) {
                smallest_error = total_error;
                best = c;
                ibest = i;
            }
            total_error -= new_error;
            total_error += old_error;
            c.decrementTimesUsed();
        }
        if (best != null) {
            this.history[this.icirc] = best;
            best.incrementTimesUsed();
            best.incrementRawCount();
            if (log.isDebugEnabled()) {
                this.logGoals();
                this.logActuals(ibest);
                log.debug("===============================");
            }
        } else {
            log.debug("no node chosen");
        }
        return best;
    }

    private void debugCurrentError(int i, double total_error, double old_error, double new_error, double inProgressError, ArrayList<Candidate> list2, double[] errors) {
        NumberFormat form = CandidateList.getFormat();
        StringBuffer sb = new StringBuffer();
        sb.append("i=\t").append(i);
        sb.append("\tinProgressError=").append(inProgressError);
        errors[i] = new_error;
        for (int j = 0; j < list2.size(); ++j) {
            sb.append("\t").append(form.format(errors[j]));
        }
        sb.append("\t").append(form.format(total_error));
        cat_detail.debug(sb.toString());
        errors[i] = old_error;
    }

    static NumberFormat getFormat() {
        NumberFormat form = NumberFormat.getInstance();
        if (form instanceof DecimalFormat) {
            ((DecimalFormat)form).applyPattern("0.000");
        }
        return form;
    }

    public void logActuals(int ibest) {
        Candidate c;
        int i;
        StringBuffer sb2 = new StringBuffer();
        NumberFormat form = CandidateList.getFormat();
        sb2.append("actual:");
        for (i = 0; i < this.size(); ++i) {
            c = this.get(i);
            double d = (double)c.getTimesUsed() / (double)this.count;
            sb2.append("\t").append(form.format(d));
        }
        sb2.append("\r\ncount: ");
        for (i = 0; i < this.size(); ++i) {
            c = this.get(i);
            sb2.append("\t").append(c.getTimesUsed());
        }
        sb2.append("\r\nbest:  ");
        for (i = 0; i < this.size(); ++i) {
            sb2.append("\t");
            if (i != ibest) continue;
            sb2.append("X");
        }
        log.debug(sb2.toString());
    }

    public void logGoals() {
        StringBuffer sb2 = new StringBuffer();
        NumberFormat form = CandidateList.getFormat();
        sb2.append("goals: ");
        for (int i = 0; i < this.size(); ++i) {
            Candidate c = this.get(i);
            double d = c.getNormalizedWeight();
            sb2.append("\t").append(form.format(d));
        }
        log.debug(sb2.toString());
    }

    public boolean isAvailableLocally(String serviceName) {
        return this.isAvailableLocally;
    }

    public void add(Candidate candidate) {
        int index = this.indexOf(candidate);
        if (index == -1) {
            this.list.add(candidate);
        } else {
            this.list.set(index, candidate);
        }
    }

    private int indexOf(Candidate candidate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(candidate.getObject())) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.list.size();
    }

    public Iterator<Candidate> iterator() {
        return this.list.iterator();
    }

    public Candidate get(int i) {
        return this.list.get(i);
    }
}

