/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.impl.AsyncPipedInputStream;
import com.cognos.pogo.async.impl.AsyncPipedOutputStream;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class AsyncServiceBase
implements AsyncService {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncServiceBase.class.getName());
    private int asyncThreshold;

    @Override
    public final void cancel(MessageContext mc, AsyncContext ac) {
        if (logger.isDebugEnabled()) {
            logger.debug("cancel() called on " + ac.toString() + ", will call cancelImpl()");
        }
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope respEnv = AsyncServiceBase.prepareSkeletalResponse(requestEnv, mc, null);
        respEnv.setConversationContextStatus("complete");
        this.cancelImpl(mc, ac);
    }

    protected abstract void cancelImpl(MessageContext var1, AsyncContext var2);

    @Override
    public final void abandon(AsyncContext ac) {
        logger.debug("abandon() called, calling abandonImpl()");
        this.abandonImpl(ac);
    }

    public abstract void abandonImpl(AsyncContext var1);

    @Override
    public int getAsyncThreshold() {
        return this.asyncThreshold;
    }

    public void setAsyncThreshold(int threshold) {
        this.asyncThreshold = threshold;
    }

    public static BIBusEnvelope prepareSkeletalResponse(BIBusEnvelope requestEnv, MessageContext mc, QName responseQName) {
        Element ffVars;
        BIBusEnvelope respEnv = new BIBusEnvelope();
        requestEnv.copyBiBusHeaderTo(respEnv);
        Element respHdr = respEnv.getHeader();
        Element envVars = respHdr.element(BIBusEnvelope.BUS_ENVIRONMENT_VARS);
        if (envVars != null) {
            envVars.detach();
        }
        if ((ffVars = respHdr.element(BIBusEnvelope.BUS_FORM_FIELD_VARS)) != null) {
            ffVars.detach();
        }
        if (responseQName != null) {
            respEnv.getBody().addElement(responseQName);
        }
        mc.setResponseName("response");
        mc.setProperty("response.status_code", "200");
        mc.setProperty("response.envelope", respEnv);
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=utf-8");
        mc.setProperty("response.headers", headers);
        mc.setProperty("response.boundary", null);
        mc.setProperty("response.attachments", null);
        return respEnv;
    }

    @Override
    public final void working(MessageContext mc, AsyncContext ac) {
        if (logger.isDebugEnabled()) {
            logger.debug("working() called on " + ac.toString() + ", will call workingImpl()");
        }
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope respEnv = AsyncServiceBase.prepareSkeletalResponse(requestEnv, mc, null);
        respEnv.setConversationContextStatus("working");
        this.workingImpl(mc, ac);
    }

    public abstract void workingImpl(MessageContext var1, AsyncContext var2);

    @Override
    public final void stillWorking(MessageContext mc, AsyncContext ac) {
        if (logger.isDebugEnabled()) {
            logger.debug("stillWorking() called on " + ac.toString() + ", will call stillWorkingImpl()");
        }
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope respEnv = AsyncServiceBase.prepareSkeletalResponse(requestEnv, mc, null);
        respEnv.setConversationContextStatus("stillWorking");
        this.stillWorkingImpl(mc, ac);
    }

    public abstract void stillWorkingImpl(MessageContext var1, AsyncContext var2);

    @Override
    public void responseReady(MessageContext mc, AsyncContext ac) {
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope respEnv = AsyncServiceBase.prepareSkeletalResponse(requestEnv, mc, null);
        this.responseReadyImpl(mc, ac);
        respEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        if (respEnv != null) {
            String status = respEnv.getConversationContextStatus();
            if (status == null || status.length() == 0) {
                logger.debug("in responseReady, service did not set conversation status, so setting it to \"complete\"");
                respEnv.setConversationContextStatus("complete");
                return;
            }
            if ("complete".equals(status) || "conversationComplete".equals(status) || "stillWorking".equals(status)) {
                return;
            }
            logger.warn("in responseReady, service set invalid conversation state:\"" + status + "\", force it to complete.");
            respEnv.setConversationContextStatus("complete");
        }
    }

    protected void collectResponse(MessageContext source, MessageContext dest) {
        ((MessageContextImpl)dest).collectResponse((MessageContextImpl)source);
    }

    public void responseReadyImpl(MessageContext mc, AsyncContext ac) {
    }

    @Override
    public final void getOutput(MessageContext mc, AsyncContext ac) {
        if (logger.isDebugEnabled()) {
            logger.debug("getOutput() called on " + ac.toString() + ", calling getOutputImpl()");
        }
        this.getOutputImpl(mc, ac);
        ((MessageContextImpl)mc).collectResponse((MessageContextImpl)ac.getMessageContext());
    }

    public abstract void getOutputImpl(MessageContext var1, AsyncContext var2);

    @Override
    public final void release(MessageContext mc) {
        if (logger.isDebugEnabled()) {
            logger.debug("release() called, will call releaseImpl()");
        }
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusEnvelope respEnv = AsyncServiceBase.prepareSkeletalResponse(requestEnv, mc, null);
        respEnv.setConversationContextStatus("complete");
        this.releaseImpl(mc);
    }

    public abstract void releaseImpl(MessageContext var1);

    @Override
    public void waitReceived(MessageContext mc, AsyncContext ac) {
    }

    @Override
    public void openContext() {
    }

    @Override
    public void closeContext() {
    }

    public static OutputStream getAttachmentOutputStream(AsyncContext ac, MessageContext mc, String boundary) throws IOException {
        mc.setProperty(mc.getResponseName() + ".boundary", boundary);
        ArrayList<AsyncPipedInputStream> attachments = new ArrayList<AsyncPipedInputStream>();
        AsyncPipedOutputStream psSrc = null;
        AsyncPipedInputStream psSink = new AsyncPipedInputStream();
        psSrc = new AsyncPipedOutputStream(psSink, 60000);
        attachments.add(psSink);
        mc.setProperty(mc.getResponseName() + ".attachments", attachments.iterator());
        logger.debug("getAttachmentOutputStream(): call outputReady() to tell framework that output is ready");
        ac.outputReady();
        return psSrc;
    }

    @Override
    public void replyNow(MessageContext mc, AsyncContext ac) {
        BIBusEnvelope reqEnv;
        ((MessageContextImpl)mc).collectResponse((MessageContextImpl)ac.getMessageContext());
        BIBusEnvelope respEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        if (respEnv != null) {
            String status = respEnv.getConversationContextStatus();
            if (status == null || status.length() == 0) {
                logger.debug("in replyNow, service did not set conversation status, so setting it to \"conversationComplete\"");
                respEnv.setConversationContextStatus("complete");
            } else if ("complete".equals(status) || "conversationComplete".equals(status)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("in replyNow, servce set conversation status to: " + status);
                }
            } else {
                logger.warn("in replyNow, service set invalid conversation state:\"" + status + "\", force it to complete.");
                respEnv.setConversationContextStatus("complete");
            }
        }
        if ((reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope")) != null) {
            reqEnv.setConversationContextStatus("conversationComplete");
        }
    }
}

