/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.pogo.async.AsyncState;
import com.cognos.pogo.async.impl.AsyncContextImpl;
import com.cognos.pogo.async.impl.AsyncRequestQueue;
import com.cognos.pogo.async.impl.AsyncRequestThread;
import com.cognos.pogo.async.impl.AsyncThreadPool;
import com.cognos.pogo.monitoring.jmx.ThreadQueueMetrics;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AsyncController {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncController.class.getName());
    private AsyncThreadPool pool;
    private AsyncRequestQueue queue = new AsyncRequestQueue();
    private final ThreadQueueMetrics threadQueueMetrics;

    AsyncController(String name, int maxThreads, ThreadQueueMetrics threadQueueMetrics) {
        this.threadQueueMetrics = threadQueueMetrics;
        this.pool = new AsyncThreadPool(name, maxThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRequest(AsyncContextImpl context) {
        AsyncRequestThread t = null;
        AsyncThreadPool asyncThreadPool = this.pool;
        synchronized (asyncThreadPool) {
            t = this.pool.borrowThread();
            if (t == null) {
                this.queueRequest(context);
            }
        }
        if (t != null) {
            t.setController(this);
            t.wakeForRequest(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueRequest(AsyncContextImpl context) {
        AsyncRequestQueue asyncRequestQueue = this.queue;
        synchronized (asyncRequestQueue) {
            context.setQueued();
            this.queue.enqueue(context);
            this.threadQueueMetrics.setThreadQueueLength(this.queue.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyThreadAvailable(AsyncRequestThread t) {
        AsyncContextImpl context = null;
        AsyncThreadPool asyncThreadPool = this.pool;
        synchronized (asyncThreadPool) {
            if (!this.pool.isThreadValid(t)) {
                logger.debug("notifyThreadAvailable() - thread is not valid, so don't give it another request");
                return;
            }
            context = this.dequeueRequest(t);
        }
        if (context != null) {
            t.setRequest(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncContextImpl dequeueRequest(AsyncRequestThread t) {
        AsyncContextImpl context;
        AsyncRequestQueue asyncRequestQueue = this.queue;
        synchronized (asyncRequestQueue) {
            context = this.queue.dequeue();
            this.threadQueueMetrics.setThreadQueueLength(this.queue.size());
            if (context == null) {
                logger.debug("notifyThreadAvailable() - no queued requests, so thread goes back in the pool");
                this.pool.returnThread(t);
            } else {
                this.threadQueueMetrics.setTimeInThreadQueue(context.getQueuedTime());
                this.threadQueueMetrics.incrementNumberOfThreadRequests();
            }
            if (logger.isDebugEnabled() && context != null && context.getState() != AsyncState.QUEUED) {
                logger.debug("dequeued an async context that is not in \"queued\" state.  Presumably is has been cancelled already.");
            }
        }
        return context;
    }

    public int getIdleThreadCount() {
        return this.pool.getIdleThreadCount();
    }

    public int getBusyThreadCount() {
        return this.pool.getBusyThreadCount();
    }

    void setMaxThreads(int maxThreads) {
        this.pool.setMaxThreads(maxThreads);
    }

    int getMaxThreads() {
        return this.pool.getMaxThreads();
    }
}

