/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.impl;

import com.cognos.pogo.async.impl.AsyncPipedInputStream;
import java.io.IOException;
import java.io.PipedOutputStream;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AsyncPipedOutputStream
extends PipedOutputStream {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AsyncPipedOutputStream.class.getName());
    private boolean firstWrite = true;
    private AsyncPipedInputStream sink;
    private int sinkActiveTimeLimit;

    public AsyncPipedOutputStream(AsyncPipedInputStream sink, int sinkActiveTimeLimit) throws IOException {
        super(sink);
        this.sink = sink;
        this.sinkActiveTimeLimit = sinkActiveTimeLimit;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkSinkActive();
        super.write(b, off, len);
    }

    private void checkSinkActive() throws IOException {
        if (this.firstWrite) {
            this.firstWrite = false;
            logger.debug("calling waitForSinkReader()");
            boolean thereIsAReader = this.sink.waitForSinkReader(this.sinkActiveTimeLimit);
            if (thereIsAReader) {
                logger.debug("someone started reading the sink");
            } else {
                logger.warn("no reader is active, give up.");
                throw new IOException("Sink not read within timelimit");
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkSinkActive();
        super.write(b);
    }
}

