/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.service;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.async.AsyncState;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.async.service.AsyncBIBusXMLHelper;
import com.cognos.pogo.async.service.AsyncRequestPassportIdManager;
import com.cognos.pogo.async.service.AsyncRequestPassportIdManagerTask;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.async.service.connection.IConnectionFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.performance.events.ConnectionRequestEvent;
import com.cognos.pogo.util.PogoLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.dom4j.Element;

public class AsyncRequestHandler
extends BasicHandler
implements Asyncable {
    static final PogoLogger logger = PogoLogger.getLogger();
    static final PogoLogger helperLogger = PogoLogger.getLoggerFor(AsyncRequestHandlerHelper.class.getName());
    private static final String RUN = "run";
    private static final String RUN_SPECIFICATION = "runSpecification";
    private static final String VALIDATE = "validate";
    private static final String VALIDATE_SPECIFICATION = "validateSpecification";
    private AsyncRequestPassportIdManager passportIdManager = new AsyncRequestPassportIdManager();
    private Element configuration;
    protected IConnectionFactory connectionFactory;
    private boolean alwaysIncludePrimaryRequest;

    private IConnectionFactory loadConnectionFactory() throws PogoException {
        IConnectionFactory connectionFactory = null;
        String factoryClassName = this.getAttribute(logger, "connectionFactory");
        try {
            connectionFactory = (IConnectionFactory)Class.forName(factoryClassName).newInstance();
        }
        catch (Exception e) {
            logger.fatalError("unable to instantiate object factory " + factoryClassName, e);
            throw new PogoException("unable to instantiate object factory " + factoryClassName, e);
        }
        return connectionFactory;
    }

    public AsyncRequestHandler() {
        super(logger.getNativeLogger());
    }

    @Override
    public void contextualize(Element configuration) throws PogoException {
        super.contextualize(configuration);
        this.configuration = configuration;
        this.connectionFactory = this.loadConnectionFactory();
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.connectionFactory.configure(configuration);
        String aaaConfig = configuration.getValue("AAA");
        this.passportIdManager.setPassportIdExpiryRefreshRate(aaaConfig);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        try {
            this.connectionFactory.compose(this, engine, this.configuration);
        }
        catch (PogoException e) {
            logger.error("compose_impl: problem composing connection factory.", e);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.connectionFactory.init();
    }

    @Override
    public void start() {
        super.start();
        this.connectionFactory.start();
        this.passportIdManager.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.connectionFactory.stop();
        this.passportIdManager.stop();
    }

    @Override
    public void suspend(boolean arg0) {
        super.suspend(arg0);
        this.connectionFactory.suspend(arg0);
    }

    @Override
    public void resume() {
        super.resume();
        this.connectionFactory.resume();
    }

    @Override
    public AsyncService getAsyncRequest(MessageContext mc) {
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        Boolean async = new Boolean(false);
        mc.setProperty("async", async);
        Boolean refreshPassport = new Boolean(false);
        mc.setProperty("refreshPassport", refreshPassport);
        IConnection connection = this.connectionFactory.getConnection();
        mc.setProperty("connection", connection);
        AsyncBIBusXMLHelper xmlHelper = new AsyncBIBusXMLHelper();
        mc.setProperty("xmlhelper", xmlHelper);
        Iterator itElems = reqEnv.getBody().elementIterator();
        if (!itElems.hasNext()) {
            logger.debug("getAsyncRequest() - body is emtpy, can't be an async request, return null");
            return null;
        }
        Element method = (Element)itElems.next();
        if (method.getName().equals(RUN) || method.getName().equals(RUN_SPECIFICATION) || method.getName().equals(VALIDATE_SPECIFICATION) || method.getName().equals(VALIDATE)) {
            async = new Boolean(true);
            mc.setProperty("async", async);
            Boolean multipart = new Boolean(false);
            mc.setProperty("multipart", multipart);
            this.alwaysIncludePrimaryRequest = AsyncBIBusXMLHelper.getAlwaysIncludePrimaryRequest(method);
            int threshold = AsyncBIBusXMLHelper.getPrimaryWaitThreshold(method);
            if (threshold > 0) {
                refreshPassport = new Boolean(true);
                mc.setProperty("refreshPassport", refreshPassport);
                return new AsyncRequestHandlerHelper(this, threshold);
            }
        } else if (method.getName().equals("release")) {
            return new AsyncRequestHandlerHelper(this, 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        AsyncBIBusXMLHelper xmlHelper;
        boolean async;
        AsyncRequestPassportIdManagerTask passportIdManagerTask;
        block12: {
            passportIdManagerTask = null;
            try {
                IConnection connection;
                boolean answerWithFault;
                boolean refreshPassport;
                logger.debug("synchronous execution");
                async = (Boolean)mc.getProperty("async");
                BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
                xmlHelper = (AsyncBIBusXMLHelper)mc.getProperty("xmlhelper");
                if (async) {
                    xmlHelper.cachePrimaryRequestInfo(request, this.alwaysIncludePrimaryRequest);
                }
                if (refreshPassport = ((Boolean)mc.getProperty("refreshPassport")).booleanValue()) {
                    passportIdManagerTask = this.passportIdManager.addPassportIdManagerTask(request.getPassportID());
                }
                if (!(answerWithFault = (connection = (IConnection)mc.getProperty("connection")).invokeRequest(mc))) break block12;
                try {
                    logger.debug("answering with fault");
                    if (!mc.isFaulted()) {
                        throw new Exception("MYMETHOD_FAILED_EXCEPTION");
                    }
                }
                catch (Exception x) {
                    mc.setFault(new Fault("MYMETHOD_FAILED", x));
                }
                if (passportIdManagerTask != null) {
                    this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
                }
                return;
            }
            catch (Throwable throwable) {
                if (passportIdManagerTask != null) {
                    this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
                }
                throw throwable;
            }
        }
        if (async) {
            xmlHelper.prepareCompletedPrimaryResponse(mc);
        }
        if (passportIdManagerTask != null) {
            this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncInvoke(AsyncContext ac) {
        AsyncBIBusXMLHelper xmlHelper;
        MessageContext mc;
        AsyncRequestPassportIdManagerTask passportIdManagerTask;
        block13: {
            boolean answerWithFault;
            block12: {
                answerWithFault = false;
                passportIdManagerTask = null;
                try {
                    logger.debug("asynchronous execution");
                    mc = ac.getMessageContext();
                    BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
                    xmlHelper = (AsyncBIBusXMLHelper)mc.getProperty("xmlhelper");
                    xmlHelper.cachePrimaryRequestInfo(request, this.alwaysIncludePrimaryRequest);
                    boolean refreshPassport = (Boolean)mc.getProperty("refreshPassport");
                    if (refreshPassport) {
                        passportIdManagerTask = this.passportIdManager.addPassportIdManagerTask(request.getPassportID());
                    }
                    mc.setProperty("connectionAssignmentInterlock", ac.getConnectionAssignmentInterlock());
                    answerWithFault = this.executeRequest(mc);
                    if (ac.getState() == AsyncState.EXECUTING) break block12;
                    logger.debug("state \"", ac.getState(), "\" is not \"executing\", I guess we've been cancelled");
                    mc.setFault(new Fault("REQUEST_CANCELLED"));
                    if (passportIdManagerTask != null) {
                        this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (passportIdManagerTask != null) {
                        this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
                    }
                    throw throwable;
                }
            }
            if (!answerWithFault) break block13;
            try {
                logger.debug("answering with fault");
                if (!mc.isFaulted()) {
                    throw new Exception("MYMETHOD_FAILED_EXCEPTION");
                }
            }
            catch (Exception x) {
                mc.setFault(new Fault("MYMETHOD_FAILED", x));
            }
            if (passportIdManagerTask != null) {
                this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
            }
            return;
        }
        xmlHelper.prepareCompletedPrimaryResponse(mc);
        if (passportIdManagerTask != null) {
            this.passportIdManager.removePassportIdManagerTask(passportIdManagerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeRequest(MessageContext mc) {
        ConnectionRequestEvent perfEvent = new ConnectionRequestEvent(mc);
        try {
            IConnection connection = (IConnection)mc.getProperty("connection");
            boolean bl = connection.invokeRequest(mc);
            return bl;
        }
        finally {
            perfEvent.completed();
        }
    }

    class CleanupFileInputStream
    implements Cleanable {
        private FileInputStream fis;

        CleanupFileInputStream(FileInputStream fis) {
            this.fis = fis;
        }

        @Override
        public void clean(MessageContext mc) {
            try {
                logger.debug("CleanupFileInputStream: closing file.");
                this.fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class AsyncRequestHandlerHelper
    extends AsyncServiceBase {
        private AsyncRequestHandler handler;
        private boolean getOutputRequired = false;

        public AsyncRequestHandlerHelper(AsyncRequestHandler handler, int threshold) {
            this.handler = handler;
            this.setAsyncThreshold(threshold);
        }

        @Override
        public void invoke(AsyncContext ac) {
            helperLogger.debug("invoked: ", ac);
            ac.getMessageContext().setProperty("theAsyncContext", ac);
            this.handler.asyncInvoke(ac);
            helperLogger.debug("finished: ", ac);
        }

        @Override
        public void waitReceived(MessageContext mc, AsyncContext ac) {
            helperLogger.debug("waitReceived() was called");
            this.setAsyncThreshold(AsyncBIBusXMLHelper.getSecondaryWaitThreshold(mc));
            IConnection connection = (IConnection)ac.getMessageContext().getProperty("connection");
            if (connection != null) {
                connection.waitReceivedForRequest(mc, ac);
            }
        }

        @Override
        protected void cancelImpl(MessageContext mc, AsyncContext ac) {
            helperLogger.debug("cancelImpl was called: ", ac);
            IConnection connection = (IConnection)ac.getMessageContext().getProperty("connection");
            if (connection != null) {
                connection.cancelRequest(mc, ac);
            }
            AsyncBIBusXMLHelper xmlHandler = (AsyncBIBusXMLHelper)ac.getMessageContext().getProperty("xmlhelper");
            xmlHandler.prepareCancelResponse(mc);
        }

        @Override
        public void abandonImpl(AsyncContext ac) {
            helperLogger.debug("abandonImpl was called: ", ac);
            IConnection connection = (IConnection)ac.getMessageContext().getProperty("connection");
            if (connection != null) {
                connection.abandonRequest(ac.getMessageContext(), ac);
            }
        }

        @Override
        public void workingImpl(MessageContext mc, AsyncContext ac) {
            helperLogger.debug("workingImpl was called");
            AsyncBIBusXMLHelper xmlHandler = (AsyncBIBusXMLHelper)ac.getMessageContext().getProperty("xmlhelper");
            xmlHandler.prepareWorkingResponse(mc);
        }

        @Override
        public void stillWorkingImpl(MessageContext mc, AsyncContext ac) {
            helperLogger.debug("stillWorkingImpl was called");
            AsyncBIBusXMLHelper xmlHandler = (AsyncBIBusXMLHelper)ac.getMessageContext().getProperty("xmlhelper");
            xmlHandler.prepareStillWorkingResponse(mc);
        }

        @Override
        public void releaseImpl(MessageContext mc) {
            helperLogger.debug("releaseImpl was called.");
            IConnection connection = (IConnection)mc.getProperty("connection");
            connection.releaseRequest(mc);
            AsyncBIBusXMLHelper xmlHandler = (AsyncBIBusXMLHelper)mc.getProperty("xmlhelper");
            xmlHandler.prepareReleaseResponse(mc);
        }

        @Override
        public void responseReadyImpl(MessageContext mc, AsyncContext ac) {
            helperLogger.debug("responseReadyImpl was called.");
            if (this.getOutputRequired) {
                logger.debug("responseReadyImpl, getOutput call is required");
                BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
                AsyncBIBusXMLHelper xmlHandler = (AsyncBIBusXMLHelper)ac.getMessageContext().getProperty("xmlhelper");
                xmlHandler.prepareStillWorkingResponse(mc);
                response.setConversationContextStatus("stillWorking");
            } else {
                logger.debug("responseReadyImpl, no getOutput call is expected.");
                this.collectResponse(ac.getMessageContext(), mc);
            }
        }

        @Override
        public void getOutputImpl(MessageContext mc, AsyncContext ac) {
            helperLogger.debug("getOutputImpl() called.");
            BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
            AsyncBIBusXMLHelper xmlHandler = (AsyncBIBusXMLHelper)ac.getMessageContext().getProperty("xmlhelper");
            xmlHandler.prepareGetOutputResponse(mc);
            response.setConversationContextStatus("complete");
        }
    }
}

