/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.service.connection.bibustkserver;

import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerRequestInvoker;
import com.cognos.pogo.bibus.SOAPAction;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.reportservice.ConnectionAssignmentInterlock;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class BIBusTKServerConnection
implements IConnection {
    private BIBusTKServerRequestInvoker requestInvoker;

    public BIBusTKServerConnection(BIBusTKServerRequestInvoker requestInvoker) {
        this.requestInvoker = requestInvoker;
    }

    private BIBusEnvelope createCancelEnvelope(BIBusEnvelope originalReqEnv) {
        BIBusEnvelope cancelEnvelope = new BIBusEnvelope();
        if (originalReqEnv != null) {
            originalReqEnv.copyBiBusHeaderTo(cancelEnvelope);
        }
        Element body = cancelEnvelope.getBody();
        Element cancelElement = body.addElement("cancel");
        Element conversationElement = cancelElement.addElement("conversation");
        conversationElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":asynchRequest");
        conversationElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        return cancelEnvelope;
    }

    @Override
    public boolean abandonRequest(MessageContext messageContext, AsyncContext ac) {
        BIBusEnvelope reqEnv = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        BIBusEnvelope cancelEnv = this.createCancelEnvelope(reqEnv);
        MessageContextImpl mcCancel = new MessageContextImpl();
        mcCancel.setProperty("request.envelope", cancelEnv);
        String sa = (String)messageContext.getProperty("request.soapaction");
        SOAPAction soapAction = new SOAPAction(sa);
        soapAction.setSuffix("control");
        mcCancel.setProperty("request.soapaction", soapAction.getComplete());
        mcCancel.setProperty("tmp.worker_request_path", "/cancel");
        ArrayList cleanupList = new ArrayList();
        mcCancel.setProperty("cleanup", cleanupList);
        mcCancel.setProperty("request.headers", messageContext.getProperty("request.headers"));
        this.cancelRequest(mcCancel, ac);
        for (int i = 0; i < cleanupList.size(); ++i) {
            ((Cleanable)cleanupList.get(i)).clean(mcCancel);
        }
        return false;
    }

    @Override
    public boolean cancelRequest(MessageContext mc, AsyncContext ac) {
        ConnectionAssignmentInterlock connInfo = null;
        if (ac != null) {
            connInfo = ac.getConnectionAssignmentInterlock();
        }
        if (connInfo != null) {
            if (!connInfo.preventAssignment()) {
                BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
                reqEnv.setConversationContextProcessID(connInfo.getProcessID());
                this.requestInvoker.invoke(mc);
            }
        } else {
            this.requestInvoker.invoke(mc);
        }
        return false;
    }

    @Override
    public boolean getOutputForRequest(MessageContext mc) {
        this.requestInvoker.invoke(mc);
        return false;
    }

    @Override
    public boolean invokeRequest(MessageContext mc) {
        this.requestInvoker.invoke(mc);
        if (mc.isFaulted()) {
            return true;
        }
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element responseBody = response.getBody();
        if (responseBody != null) {
            List bodyContent = responseBody.content();
            Element faultElement = null;
            for (int i = 0; i < bodyContent.size(); ++i) {
                if (!(bodyContent.get(i) instanceof Element)) continue;
                faultElement = (Element)bodyContent.get(i);
                break;
            }
            if (faultElement != null && faultElement.getName() == "Fault") {
                Fault fault = new Fault("Error", response);
                mc.setFault(fault);
            }
        }
        return mc.isFaulted();
    }

    @Override
    public boolean releaseRequest(MessageContext mc) {
        this.requestInvoker.invoke(mc);
        return false;
    }

    @Override
    public boolean waitReceivedForRequest(MessageContext mc, AsyncContext ac) {
        ConnectionAssignmentInterlock connInfo = null;
        if (ac != null) {
            connInfo = ac.getConnectionAssignmentInterlock();
        }
        if (connInfo != null) {
            int processId = connInfo.getProcessID();
            if (processId == -2 || processId > 0) {
                BIBusEnvelope secondaryRequestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                secondaryRequestEnvelope.setConversationContextProcessID(processId);
                this.requestInvoker.invoke(mc);
            }
        } else {
            return this.oldWaitReceivedForRequest(mc, ac);
        }
        return false;
    }

    private boolean oldWaitReceivedForRequest(MessageContext mc, AsyncContext ac) {
        BIBusEnvelope primaryRequestEnvelope = (BIBusEnvelope)ac.getMessageContext().getProperty("request.envelope");
        BIBusEnvelope secondaryRequestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        int processId = primaryRequestEnvelope.getConversationContextProcessID();
        if (processId == -2 || processId > 0) {
            secondaryRequestEnvelope.setConversationContextProcessID(processId);
            this.requestInvoker.invoke(mc);
        }
        return false;
    }

    @Override
    public boolean release() {
        return false;
    }
}

