/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.async.service.connection.bibustkserver;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.async.service.AsyncRequestHandler;
import com.cognos.pogo.async.service.bibustkserver.BIBusTKServerRequestHandler;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.async.service.connection.IConnectionFactory;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerComponentFactory;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerConnection;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerInProgressRequests;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerManager;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerRequestInvoker;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.QueueableRequestReportingHandler;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportGeneralList;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportMonitor;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.ReportServerAttributeMonitor;
import com.cognos.pogo.reportservice.ReportServerInProgressRequests;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.ProcessExecutionMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.dom4j.Element;

public class BIBusTKServerConnectionFactory
implements IConnectionFactory {
    private static final PogoLogger logger = PogoLogger.getLogger();
    private long requestExpirationTime = 30000L;
    private boolean usessl;
    private String cleanListName;
    private boolean prestartProcess = false;
    protected BIBusTKServerComponentFactory componentFactory;
    private Element initialConfiguration;
    private String servicePrefix;
    private PogoEngine pogoEngine;
    protected BIBusTKServerManager processManager;
    protected ReportServerQueue processQueue;
    private BIBusTKServerInProgressRequests inProgressRequests;
    protected InteractiveReportExecutingRequests executingRequests;
    protected BIBusTKServerRequestInvoker requestInvoker;
    private QueueableRequestReportingHandler queueableReportingHandler;
    private ReportServerAttributeMonitor attributeMonitor;
    protected String serviceName;
    private ProcessExecutionMode processExecutionMode;

    private String getRequiredAttribute(PogoLogger cat, String name) throws PogoException {
        String at = this.initialConfiguration.attributeValue(name);
        if (at == null || at.length() == 0) {
            cat.error("required attribute \"" + name + "\" is missing on handler " + BIBusTKServerConnectionFactory.class.getName());
            throw new PogoException("handler requires \"" + name + "\" attribute");
        }
        return at;
    }

    private Map<String, String> getInitParams(List<Element> initParamList) {
        if (initParamList == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> initParamsMap = new HashMap<String, String>(initParamList.size());
        for (Element initParamElement : initParamList) {
            initParamsMap.put(initParamElement.elementTextTrim("param-name"), initParamElement.elementTextTrim("param-value"));
        }
        return initParamsMap;
    }

    public String[] getProcessArguments(List<Element> childProcCmdList, Map<String, String> initParamMap) throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        String exeName = this.processExecutionMode.getProcessName();
        argList.add(exeName);
        String maxThreads = initParamMap.get("threads");
        int childProcessThreads = 10;
        if (maxThreads != null) {
            try {
                childProcessThreads = Integer.parseInt(maxThreads);
                if (childProcessThreads != -1) {
                    childProcessThreads = 10;
                }
            }
            catch (NumberFormatException nfx) {
                childProcessThreads = 10;
                logger.error("failed to parse value of threads configured by init-param: ", maxThreads);
            }
            logger.debug("using value of threads configured by init-param: ", childProcessThreads);
        }
        argList.add("threads=" + childProcessThreads);
        argList.add("camssl=" + (this.usessl ? "true" : "false"));
        argList.add("COG_ROOT=");
        Iterator<Element> iterator = childProcCmdList.iterator();
        while (iterator.hasNext()) {
            argList.add(iterator.next().getTextTrim());
        }
        String[] args = new String[argList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (String)argList.get(i);
        }
        return args;
    }

    private void getComponentFactory(AsyncRequestHandler handler) throws PogoException {
        String factoryClassName = this.getRequiredAttribute(logger, "objectFactory");
        try {
            this.componentFactory = (BIBusTKServerComponentFactory)Class.forName(factoryClassName).newInstance();
            this.componentFactory.setHandler((BIBusTKServerRequestHandler)handler);
        }
        catch (Exception e) {
            logger.fatalError("unable to instantiate object factory " + factoryClassName, e);
            throw new PogoException("unable to instantiate object factory " + factoryClassName, e);
        }
    }

    private void initRequestInvoker(Element configuration) throws PogoException {
        Element targetElement = configuration.element("target");
        Map<String, String> initParamsMap = this.getInitParams(targetElement.elements("init-param"));
        this.executingRequests = this.componentFactory.newInteractiveReportExecutingRequests();
        this.requestInvoker = (BIBusTKServerRequestInvoker)this.componentFactory.newRequestInvoker(this.executingRequests);
        this.requestInvoker.setCnRequestInfo(this.getRequiredAttribute(logger, "cnRequestInfo"));
        this.requestInvoker.setDefaultTimeout(Integer.parseInt(initParamsMap.get("queue_time_limit_ms")));
        this.requestInvoker.setReportServerPath(initParamsMap.get("worker_request_path"));
        this.cleanListName = this.getRequiredAttribute(logger, "cn_cleanup_list");
        this.requestInvoker.setCleanListName(this.cleanListName);
    }

    private void initProcessManager(PogoEngine engine, Element configuration) throws NumberFormatException, IOException, PogoException {
        this.setupUseSSL();
        Element targetElement = configuration.element("target");
        List childProcCmdList = targetElement.elements("child-proc-cmd");
        Map<String, String> initParamsMap = this.getInitParams(targetElement.elements("init-param"));
        this.processExecutionMode = new ProcessExecutionMode(initParamsMap);
        String[] args = this.getProcessArguments(childProcCmdList, initParamsMap);
        this.createProcessManager(targetElement, initParamsMap, args);
        this.setupMinAndMaxProcessCount(initParamsMap);
        int shutdownTimeLimit = Integer.parseInt(initParamsMap.get("process_shutdown_timeout_ms"));
        this.processManager.setShutdownTimeLimit(shutdownTimeLimit);
        this.setupIdleProcessCheck(initParamsMap);
        this.processManager.setRequestCountLimit(Integer.parseInt(initParamsMap.get("default_process_use_limit")));
        this.processQueue.setProcessList(this.processManager.getProcessList());
        this.prestartProcess = Boolean.valueOf(initParamsMap.get("prestart_process"));
        this.attributeMonitor = this.componentFactory.newReportServerAttributeMonitor(configuration);
        this.extractProcessCleanerInterval(initParamsMap);
    }

    private void setupMinAndMaxProcessCount(Map<String, String> initParamsMap) {
        this.processManager.setMinProcessCount(Integer.parseInt(initParamsMap.get("linger_process")));
        int maxProcNum = Integer.parseInt(initParamsMap.get("max_process"));
        this.processManager.setMaxProcessCount(maxProcNum);
    }

    private void setupIdleProcessCheck(Map<String, String> initParamsMap) {
        int idle_process_check_interval_ms = Integer.parseInt(initParamsMap.get("idle_process_check_interval_ms"));
        int idle_process_max_idle_ticks = Integer.parseInt(initParamsMap.get("idle_process_max_idle_ticks"));
        String optionalMaxWaitParam = initParamsMap.get("max_wait_for_expired_process_to_become_idle_secs");
        long idle_max_wait = optionalMaxWaitParam != null ? (long)Integer.parseInt(optionalMaxWaitParam) : -1L;
        this.processManager.setIdleProcessTimeout(idle_process_check_interval_ms, idle_process_max_idle_ticks, idle_max_wait);
    }

    private void createProcessManager(Element targetElement, Map<String, String> initParamsMap, String[] args) {
        int reportServerPort = Integer.parseInt(initParamsMap.get("report_server_port"));
        String reportServerHost = "localhost";
        if (reportServerPort > 0) {
            reportServerHost = initParamsMap.get("report_server_host");
        }
        this.processQueue = this.componentFactory.newReportServerQueue();
        String procManThreadName = BIBusTKServerConnectionFactory.class.getName() + "-" + this.servicePrefix + "ProcessManager";
        this.processManager = (BIBusTKServerManager)this.componentFactory.newProcessManager(procManThreadName, this.processQueue, args, targetElement, reportServerHost, reportServerPort, this.usessl);
    }

    private void setupUseSSL() throws PogoException {
        String protocolProperty = PropertyInserter.getProperty("internalDispatcher.protocol");
        this.usessl = "https".equalsIgnoreCase(protocolProperty);
        if ("true".equals(this.getRequiredAttribute(logger, "preventSSL"))) {
            this.usessl = false;
        }
    }

    public void extractProcessCleanerInterval(Map<String, String> initParamsMap) {
        try {
            int processCleanerInterval = this.getIntInitParam(initParamsMap, "process_cleaner_interval");
            this.processManager.setProcessCleanerInterval(processCleanerInterval);
        }
        catch (NumberFormatException e) {
            logger.warn("process_cleaner_interval is invalid, default will be used.");
        }
    }

    private int getIntInitParam(Map<String, String> initParamsMap, String paramName) throws NumberFormatException {
        return Integer.parseInt(initParamsMap.get(paramName));
    }

    private void initRequestMonitor(Element configuration) {
        Element targetElement = configuration.element("target");
        Map<String, String> initParamsMap = this.getInitParams(targetElement.elements("init-param"));
        this.inProgressRequests = (BIBusTKServerInProgressRequests)this.componentFactory.newReportServerInProgressRequests();
        logger.debug("Current async_wait_timeout_ms value: ", this.requestExpirationTime);
        this.requestExpirationTime = Integer.parseInt(initParamsMap.get("async_wait_timeout_ms"));
        logger.debug("async_wait_timeout_ms value from configuration file: ", this.requestExpirationTime);
    }

    protected void configureRequestInvoker(Configuration configuration) {
        this.requestInvoker.setDispatcherGuid(NodeID.getSelf().getGuid());
        String propname = this.servicePrefix + "QueueLimit";
        try {
            int queueLimit = this.parseIntPropertyFromConfiguration(configuration, propname) * 1000;
            if (Check.isValidTimeoutValue(queueLimit)) {
                this.requestInvoker.setDefaultTimeout(queueLimit);
            }
        }
        catch (NumberFormatException ex) {
            logger.info("configureRequestInvoker: Configuration property '", propname, "' did not return an integer.  Ignoring configuration update");
        }
    }

    private String getConfigValue(Configuration configuration, String propName, boolean inPeakDemandPeriod) {
        String value;
        String propertyPrefix = this.servicePrefix;
        if (inPeakDemandPeriod) {
            propertyPrefix = propertyPrefix + "Peak";
        }
        if ((value = configuration.getValue(propertyPrefix + propName)) == null || value.length() == 0) {
            value = configuration.getValue(this.servicePrefix + propName);
        }
        return value;
    }

    void configureProcessManager(Configuration configuration) throws PogoException {
        Element configurationFromCM = configuration.getCmResponse();
        if (configurationFromCM == null) {
            logger.error("configureProcessManager: No configuration element from CM");
        } else {
            this.processManager.setCclConfiguration(configurationFromCM);
        }
        boolean inPeakDemandPeriod = "true".equalsIgnoreCase(configuration.getValue("inPeakDemandPeriod"));
        try {
            int maxProcess;
            String propertyPrefix = this.servicePrefix;
            if (inPeakDemandPeriod) {
                propertyPrefix = propertyPrefix + "Peak";
            }
            try {
                maxProcess = Integer.parseInt(this.getConfigValue(configuration, "MaximumProcesses", inPeakDemandPeriod));
            }
            catch (NumberFormatException nfx) {
                logger.info("configureProcessManager() - unable to parse configuration value ", propertyPrefix, "MaximumProcesses, using default value of 1");
                maxProcess = 1;
            }
            this.processManager.setMaxProcessCount(maxProcess);
            String affineConnectionsStr = this.getConfigValue(configuration, "AffineConnections", inPeakDemandPeriod);
            String nonAffineConnectionsStr = this.getConfigValue(configuration, "NonAffineConnections", inPeakDemandPeriod);
            if (affineConnectionsStr != null && affineConnectionsStr.length() > 0 && nonAffineConnectionsStr != null && nonAffineConnectionsStr.length() > 0) {
                int affineConnections = Integer.parseInt(affineConnectionsStr);
                int nonAffineConnections = Integer.parseInt(nonAffineConnectionsStr);
                this.processManager.updateConnectionsPerProcess(affineConnections, nonAffineConnections);
                logger.debug("configureProcessManager(): set maxProcess=", maxProcess, ", affineConnections=", affineConnections, ", nonAffineConnections=", nonAffineConnections);
            }
        }
        catch (NumberFormatException e) {
            logger.info("Invalid connection config value. Ignoring configuration update.", e);
        }
        this.processManager.updateActiveCM(configuration.getValue("contentManager"));
        this.processManager.correctProcessBinaryPath(configuration.getICCLConfiguration());
        this.updateExecutionModeParameters(this.processManager, configuration);
        this.processManager.setAdvancedSettings(configuration);
        if (this.attributeMonitor.checkConfiguration(configuration)) {
            this.processManager.setConfigurationChanged();
        }
        this.processManager.useNewConfiguration();
    }

    private void updateExecutionModeParameters(ProcessManager processManager2, Configuration configuration) {
        this.processExecutionMode.setCclConfiguration(configuration.getICCLConfiguration());
        this.processExecutionMode.prepareWorkingDir(processManager2);
        this.processExecutionMode.prepareEnvironment(processManager2);
    }

    protected void configureProcessQueue(Configuration configuration) {
        String propname = this.servicePrefix + "QueueLimit";
        try {
            int queueLimit = this.parseIntPropertyFromConfiguration(configuration, propname) * 1000;
            if (Check.isValidTimeoutValue(queueLimit)) {
                this.processQueue.setDefaultTimeout(queueLimit);
            }
        }
        catch (NumberFormatException ex) {
            logger.debug("configureProcessQueue: Configuration property '", propname, "' did not return an integer.  Ignoring configuration update");
        }
    }

    protected void configureRequestMonitor(Configuration configuration) {
        String propname = this.servicePrefix + "ExecutionTimeLimit";
        try {
            int executionLimit = this.parseIntPropertyFromConfiguration(configuration, propname);
            logger.debug("configureRequestMonitor:  Using execution time limit (in seconds) -> ", executionLimit);
            if (executionLimit != -1) {
                this.inProgressRequests.setExecutionTimeLimit(executionLimit);
            }
        }
        catch (NumberFormatException ex) {
            logger.debug("configureRequestMonitor:  Configuration property '", propname, "' did not return an integer.  Ignoring configuration update");
        }
    }

    private void startRequestMonitor() {
        this.inProgressRequests.startExpirationTimer(this.requestExpirationTime);
    }

    private void startProcessManager() {
        int minProcessCount = this.processManager.getMinProcessCount();
        int maxProcessCount = this.processManager.getMaxProcessCount();
        minProcessCount = Math.min(minProcessCount, maxProcessCount);
        if (this.prestartProcess && minProcessCount > 0) {
            this.processManager.createAnotherProcess(minProcessCount);
        }
        this.processManager.start();
    }

    private void stopProcessQueue() {
        if (this.processQueue != null) {
            this.processQueue.shutdown();
        }
    }

    private void stopProcessManager() {
        if (this.processManager != null) {
            this.processManager.shutdown();
        }
    }

    private void stopRequestMonitor() {
        if (this.inProgressRequests != null) {
            this.inProgressRequests.cancelExpirationTimer();
        }
    }

    private void suspendProcessManager(boolean arg0) {
        this.processManager.suspend(arg0);
    }

    private void suspendProcessQueue(boolean arg0) {
        this.processQueue.suspend(arg0);
    }

    private void suspendRequestMonitor(boolean arg0) {
        this.inProgressRequests.clear();
    }

    private void resumeProcessManager() {
        this.processManager.resumeIt();
    }

    private void resumeProcessQueue() {
        this.processQueue.resume();
    }

    @Override
    public void compose(AsyncRequestHandler handler, PogoEngine engine, Element configuration) throws PogoException {
        try {
            this.pogoEngine = engine;
            this.initialConfiguration = configuration;
            this.serviceName = this.getServiceNameFromConfiguration(configuration);
            this.servicePrefix = this.getRequiredAttribute(logger, "servicePrefix");
            this.getComponentFactory(handler);
            this.initRequestInvoker(this.initialConfiguration);
            this.initProcessManager(engine, this.initialConfiguration);
            this.initRequestMonitor(this.initialConfiguration);
        }
        catch (Exception ex) {
            logger.error("problem composing " + BIBusTKServerConnectionFactory.class.getName(), ex);
            throw new PogoException(DispatcherStrings.getInstance().getString("ReportServerHandler.badConfig"), ex);
        }
    }

    String getServiceNameFromConfiguration(Element configuration) {
        return ((Element)configuration.selectSingleNode("/service")).attributeValue("name");
    }

    @Override
    public void configure(Configuration configuration) {
        if (configuration == null) {
            logger.error("configure() passed configuration is null so simply return.");
            return;
        }
        try {
            this.configureRequestInvoker(configuration);
            this.configureProcessManager(configuration);
            this.configureProcessQueue(configuration);
            this.configureRequestMonitor(configuration);
        }
        catch (Exception e) {
            logger.error("configure(): problem configuring:", e);
        }
    }

    @Override
    public void init() {
        try {
            String runTimeInfoReporter = this.getRequiredAttribute(logger, "runTimeInfoReporter");
            this.queueableReportingHandler = (QueueableRequestReportingHandler)this.pogoEngine.lookupHandler(runTimeInfoReporter);
            if (this.queueableReportingHandler == null) {
                logger.error("Lookup of reporting handler named \"", runTimeInfoReporter, "\" failed.");
            }
            this.processManager.setRequestReporter(this.queueableReportingHandler.getQueueableRequestReporter());
        }
        catch (PogoException e) {
            logger.error("problem resolving runTimeInfoReporter");
        }
    }

    @Override
    public void start() {
        this.startRequestMonitor();
        this.startProcessManager();
        this.createAndRegisterInteractiveReportMonitor();
    }

    @Override
    public void stop() {
        this.stopProcessQueue();
        this.stopProcessManager();
        this.stopRequestMonitor();
    }

    @Override
    public void suspend(boolean arg0) {
        if (!arg0) {
            return;
        }
        this.suspendProcessManager(arg0);
        this.suspendProcessQueue(arg0);
        this.suspendRequestMonitor(arg0);
    }

    @Override
    public void resume() {
        this.resumeProcessManager();
        this.resumeProcessQueue();
    }

    @Override
    public synchronized IConnection getConnection() {
        return new BIBusTKServerConnection(this.requestInvoker);
    }

    public BIBusTKServerRequestInvoker getRequestInvoker() {
        return this.requestInvoker;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public ReportServerInProgressRequests getRequestMonitor() {
        return this.inProgressRequests;
    }

    public ReportServerQueue getProcessQueue() {
        return this.processQueue;
    }

    public void testFinishedStopping() {
        if (this.queueableReportingHandler == null) {
            return;
        }
        RequestReporter reporter = this.queueableReportingHandler.getRequestReporter();
        String state = reporter.getServiceStatus();
        if (state != "stopping") {
            return;
        }
        if (this.processQueue.getQueueSize() != 0) {
            return;
        }
        if (this.inProgressRequests.size() != 0) {
            return;
        }
        logger.debug("service goes from \"STOPPING\" to \"SUSPENDED\"");
        reporter.setServiceStatus("suspended");
    }

    public void createAndRegisterInteractiveReportMonitor() {
        this.createAndRegisterInteractiveReportMonitor(this.serviceName);
    }

    public void createAndRegisterInteractiveReportMonitor(String serviceName) {
        if (!PogoMBeanServer.isNoJMX()) {
            InteractiveReportGeneralList queuedList = this.componentFactory.newInteractiveReportGeneralList(this.processQueue);
            InteractiveReportGeneralList inProgressList = this.componentFactory.newInteractiveReportGeneralList(this.executingRequests);
            InteractiveReportMonitor interactiveReportMonitor = this.componentFactory.newInteractiveReportMonitor(queuedList, inProgressList);
            this.registerInteractiveReportMonitor(interactiveReportMonitor, serviceName);
        }
    }

    protected void registerInteractiveReportMonitor(InteractiveReportMonitor interactiveReportMonitor, String serviceName) {
        MBeanServer server = PogoMBeanServer.getInstance().getServer();
        try {
            String objectName = MBeanUtils.buildObjectName("type=interactveReportMonitor,service=" + serviceName);
            logger.debug("Registered MBean: ", objectName);
            server.registerMBean(interactiveReportMonitor, MBeanUtils.createObjectNameInstance(objectName));
        }
        catch (JMException e) {
            logger.error("Exception registering interactive requests MBean", e);
        }
    }

    protected int parseIntPropertyFromConfiguration(Configuration configuration, String propname) throws NumberFormatException {
        String propnameStr = configuration.getValue(propname);
        if (propnameStr != null && propnameStr.length() > 0) {
            return Integer.parseInt(propnameStr);
        }
        logger.info(propname, " missing in Configuration");
        return -1;
    }

    public String getQueueableReportingHandlerName() {
        return this.queueableReportingHandler != null ? this.queueableReportingHandler.getName() : null;
    }

    public String getComponentFactoryName() {
        return this.componentFactory != null ? this.componentFactory.getClass().getName() : null;
    }

    public boolean getUseSSL() {
        return this.usessl;
    }

    public String getServicePrefix() {
        return this.servicePrefix;
    }

    public boolean willPrestartProcess() {
        return this.prestartProcess;
    }

    public long getRequestExpirationTime() {
        return this.requestExpirationTime;
    }

    void setProcessExecutionModeForTesting(ProcessExecutionMode executionMode) {
        this.processExecutionMode = executionMode;
    }

    void setAttributeMonitorForTesting(ReportServerAttributeMonitor attributeMonitor) {
        this.attributeMonitor = attributeMonitor;
    }
}

