/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.auth.CookieSplitter;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieDecoder {
    private static final PogoLogger log = PogoLogger.getLogger();
    protected static final String COOKIE_DECODER_PROPERTY = "CustomCookieDecoder.enabled";
    protected static final String COOKIE_DECODER_PROPERTY_DEFAULT = "true";
    protected static Boolean isEnabled = null;

    public static Cookie[] getCookies(HttpServletRequest request) {
        return CookieDecoder.isEnabled() ? CookieDecoder.getCookiesUsingCustomDecoder(request) : CookieDecoder.getCookiesUsingDefaultDecoder(request);
    }

    public static boolean isEnabled() {
        if (isEnabled == null) {
            isEnabled = CookieDecoder.getEnabledProperty();
        }
        return isEnabled;
    }

    private static Boolean getEnabledProperty() {
        return Boolean.valueOf(PropertyInserter.getProperty(COOKIE_DECODER_PROPERTY, COOKIE_DECODER_PROPERTY_DEFAULT));
    }

    private static Cookie[] getCookiesUsingCustomDecoder(HttpServletRequest request) {
        Enumeration cookieHeaders = request.getHeaders("cookie");
        Cookie[] cookies = CookieDecoder.decodeCookiesToArray(cookieHeaders);
        CookieDecoder.dumpCookies("getCookiesUsingCustomDecoder", request, cookies);
        return cookies;
    }

    private static Cookie[] decodeCookiesToArray(Enumeration<String> cookieHeaders) {
        List<Cookie> cookiesList = CookieDecoder.decodeCookiesToList(cookieHeaders);
        return CookieDecoder.toCookieArray(cookiesList);
    }

    private static List<Cookie> decodeCookiesToList(Enumeration<String> cookieHeaders) {
        ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
        if (cookieHeaders != null) {
            while (cookieHeaders.hasMoreElements()) {
                CookieDecoder.decodeCookies(cookieHeaders.nextElement(), cookiesList);
            }
        }
        return cookiesList;
    }

    private static void decodeCookies(String cookieHeader, List<Cookie> cookiesList) {
        String[] cookies;
        for (String cookie : cookies = CookieDecoder.splitCookies(cookieHeader)) {
            CookieDecoder.decodeCookie(cookie, cookiesList);
        }
    }

    private static String[] splitCookies(String cookieHeader) {
        return new CookieSplitter(cookieHeader).split();
    }

    private static void decodeCookie(String cookie, List<Cookie> cookiesList) {
        int equalPos = (cookie = cookie.trim()).indexOf(61);
        if (equalPos > 0) {
            CookieDecoder.addToCookiesList(cookie, cookiesList, equalPos);
        }
    }

    private static void addToCookiesList(String cookie, List<Cookie> cookiesList, int equalPos) {
        String name = cookie.substring(0, equalPos).trim();
        String value = cookie.substring(equalPos + 1).trim();
        CookieDecoder.addToCookiesList(name, value, cookiesList);
    }

    private static void addToCookiesList(String name, String value, List<Cookie> cookiesList) {
        Cookie newCookie = CookieDecoder.tryTocreateCookie(name, value);
        if (newCookie != null) {
            cookiesList.add(newCookie);
        }
    }

    private static Cookie tryTocreateCookie(String name, String value) {
        try {
            return CookieDecoder.createCookie(name, value);
        }
        catch (Exception e) {
            log.debug("Can't create cookie [name: ", name, ", value: ", value, "] - ", e.getMessage());
            return null;
        }
    }

    private static Cookie createCookie(String name, String value) throws Exception {
        if (CookieDecoder.isSurroundedByQuotes(value)) {
            value = CookieDecoder.removeAndUnescapeDoubleQuotes(value);
        }
        return new Cookie(name, value);
    }

    private static boolean isSurroundedByQuotes(String value) {
        return value != null && value.startsWith("\"") && value.endsWith("\"");
    }

    private static String removeAndUnescapeDoubleQuotes(String value) {
        value = CookieDecoder.unquote(value);
        return CookieDecoder.unescape(value);
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1);
    }

    private static String unescape(String value) {
        return value.replace("\\\"", "\"");
    }

    private static Cookie[] toCookieArray(List<Cookie> cookiesList) {
        Cookie[] cookiesArray = new Cookie[cookiesList.size()];
        return cookiesList.toArray(cookiesArray);
    }

    private static Cookie[] getCookiesUsingDefaultDecoder(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        CookieDecoder.dumpCookies("getCookiesUsingDefaultDecoder", request, cookies);
        return cookies;
    }

    private static void dumpCookies(String caller, HttpServletRequest request, Cookie[] cookies) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug(caller, ": Cookie decoding results");
        CookieDecoder.dumpCookieHeaders(request);
        CookieDecoder.dumpDecodedCookies(cookies);
    }

    private static void dumpCookieHeaders(HttpServletRequest request) {
        log.debug("   Cookie headers: ");
        Enumeration cookiesHeaders = request.getHeaders("cookie");
        while (cookiesHeaders.hasMoreElements()) {
            log.debug("      ", cookiesHeaders.nextElement());
        }
    }

    private static void dumpDecodedCookies(Cookie[] cookies) {
        log.debug("   Decoded cookies:");
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                log.debug("      ", cookie.getName(), "=", cookie.getValue());
            }
        }
    }
}

