/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.auth.CookieQuoter;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;

public class CookieFactory {
    private static final int DELETE = 0;
    private static String[] TLDs = new String[]{".com", ".edu", ".net", ".org", ".gov", ".mil", ".int"};

    public static Cookie createCookie(String path, String name, String value, Integer maxAge, Boolean secure, String domain) {
        String quotedValue = CookieQuoter.maybeQuoteValue(value);
        Cookie httpCookie = new Cookie(name, quotedValue);
        httpCookie.setPath(path);
        CookieFactory.maybeSetMaxAge(httpCookie, maxAge);
        CookieFactory.maybeSetSecure(httpCookie, secure);
        CookieFactory.maybeSetDomain(httpCookie, domain);
        return httpCookie;
    }

    private static void maybeSetMaxAge(Cookie httpCookie, Integer maxAge) {
        if (CookieFactory.isRegularCookie(maxAge)) {
            httpCookie.setMaxAge(maxAge.intValue());
        } else if (CookieFactory.isDeleteCookie(maxAge)) {
            httpCookie.setMaxAge(0);
        }
    }

    private static boolean isRegularCookie(Integer maxAge) {
        return maxAge != null && maxAge > 0;
    }

    private static boolean isDeleteCookie(Integer maxAge) {
        return maxAge != null && maxAge < 0;
    }

    private static void maybeSetSecure(Cookie httpCookie, Boolean secure) {
        if (secure != null) {
            httpCookie.setSecure(secure.booleanValue());
        }
    }

    private static void maybeSetDomain(Cookie httpCookie, String domain) {
        if (StringUtils.isNotEmpty((String)domain)) {
            httpCookie.setDomain(domain);
        }
    }

    public static String getDomainFromHttpHost(String http_host) {
        if (http_host == null) {
            return CookieFactory.defaultAddr();
        }
        int iColon = http_host.lastIndexOf(58);
        if (iColon != -1) {
            http_host = http_host.substring(0, iColon);
        }
        if (CookieFactory.allNumericAddr(http_host)) {
            return CookieFactory.defaultAddr();
        }
        if (CookieFactory.shouldUseDeprecatedMethod()) {
            return CookieFactory.getDomainDeprecated(http_host);
        }
        return CookieFactory.getRfc2109CompatableDomain(http_host);
    }

    private static boolean shouldUseDeprecatedMethod() {
        String property = PropertyInserter.getProperty("cookieFactory.useCognosDomainProcessing");
        return property != null && property.equalsIgnoreCase("true");
    }

    private static String getRfc2109CompatableDomain(String http_host) {
        if (!http_host.contains(".")) {
            return CookieFactory.defaultAddr();
        }
        int dotIndex = http_host.indexOf(".");
        String domain = http_host.substring(dotIndex);
        if (CookieFactory.containsTwoDots(domain)) {
            return domain;
        }
        return CookieFactory.defaultAddr();
    }

    private static boolean containsTwoDots(String domain) {
        return domain.substring(1).contains(".");
    }

    private static String getDomainDeprecated(String http_host) {
        int lastDot = http_host.lastIndexOf(46);
        if (lastDot == -1) {
            return CookieFactory.defaultAddr();
        }
        int secondLastDot = http_host.lastIndexOf(46, lastDot - 1);
        if (secondLastDot == -1) {
            return CookieFactory.defaultAddr();
        }
        String tld = http_host.substring(lastDot);
        for (int i = 0; i < TLDs.length; ++i) {
            if (!tld.equalsIgnoreCase(TLDs[i])) continue;
            return http_host.substring(secondLastDot);
        }
        int thirdLastDot = http_host.lastIndexOf(46, secondLastDot - 1);
        if (thirdLastDot == -1) {
            return CookieFactory.defaultAddr();
        }
        return http_host.substring(thirdLastDot);
    }

    private static String defaultAddr() {
        return null;
    }

    private static boolean allNumericAddr(String addr) {
        int len = addr.length();
        for (int i = 0; i < len; ++i) {
            char c = addr.charAt(i);
            if (c == '.' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

