/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import java.util.ArrayList;
import java.util.List;

public class CookieSplitter {
    private final String cookiesHeader;
    private int currentPos = 0;
    private int cookieStartPos = 0;
    private boolean isQuotedStringOpen = false;
    private List<String> splitCookies = new ArrayList<String>();

    public CookieSplitter(String cookiesHeader) {
        this.cookiesHeader = cookiesHeader;
    }

    public String[] split() {
        if (this.hasDoubleQuotes()) {
            return this.splitCookiesCharacterByCharacter();
        }
        return this.getFastCookieSplit();
    }

    private boolean hasDoubleQuotes() {
        return this.cookiesHeader.indexOf(34) >= 0;
    }

    private String[] getFastCookieSplit() {
        return this.cookiesHeader.split(";|,");
    }

    private String[] splitCookiesCharacterByCharacter() {
        this.parseCookiesHeader();
        return this.cookieArray();
    }

    private void parseCookiesHeader() {
        while (this.hasNextCharacter()) {
            this.handleCharacter();
        }
        this.handleEndOfCookiesHeader();
    }

    private boolean hasNextCharacter() {
        return this.currentPos < this.cookiesHeader.length();
    }

    private void handleCharacter() {
        switch (this.getCookieCharacter()) {
            case ',': 
            case ';': {
                this.handleCookieSeparator();
                break;
            }
            case '\"': {
                this.handleDoubleQuotes();
                break;
            }
            case '\\': {
                this.handleEscapeCharacter();
            }
        }
        this.moveToNextCharacter();
    }

    private char getCookieCharacter() {
        return this.cookiesHeader.charAt(this.currentPos);
    }

    private void handleCookieSeparator() {
        if (!this.isQuotedStringOpen) {
            this.saveCookie();
        }
    }

    private void saveCookie() {
        String cookie = this.cookiesHeader.substring(this.cookieStartPos, this.currentPos);
        this.splitCookies.add(cookie);
        this.advanceToNextCookie();
    }

    private void advanceToNextCookie() {
        this.cookieStartPos = this.currentPos + 1;
    }

    private void handleDoubleQuotes() {
        this.isQuotedStringOpen = !this.isQuotedStringOpen;
    }

    private void handleEscapeCharacter() {
        this.moveToNextCharacter();
    }

    private void moveToNextCharacter() {
        ++this.currentPos;
    }

    private void handleEndOfCookiesHeader() {
        this.saveCookie();
    }

    private String[] cookieArray() {
        return this.splitCookies.toArray(new String[this.splitCookies.size()]);
    }
}

