/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;

public class Passport {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String PASSPORT_COOKIE_NAME = "cam_passport";
    private static final String PASSPORT_FORM_NAME = "m_passportID";
    private static final String DOUBLE_QUOTE = "\"";
    private final BIBusEnvelope envelope;
    private Source source;
    private String id;
    private String cookie;
    private boolean authenticationRequired;
    private boolean rejectionRequired;
    private boolean logonRequired;
    private boolean hasPassportMismatch;

    public Passport(BIBusEnvelope envelope) {
        this.envelope = envelope;
        if (this.isSignedRequest()) {
            log.debug("Signed request received, skipping passport processing.");
        } else {
            this.processAndCopyPassport();
        }
    }

    public boolean isSignedRequest() {
        return this.envelope.getBiBusHeader().getCamProtect().isPresent();
    }

    private Cam getCam() {
        return this.envelope.getBiBusHeader().getCam();
    }

    private void processAndCopyPassport() {
        this.processPassport();
        this.tryToCopyPassportIdToBiBusHeader();
    }

    public void processPassport() {
        this.setIdAndSource();
        this.setCookie();
        this.logDebugInfo();
        this.evaluateRequirements();
    }

    private void setIdAndSource() {
        for (Source source : Source.values()) {
            String id = source.getPassportId(this);
            if (StringUtils.isEmpty((String)id)) continue;
            this.setId(id);
            this.setSource(source);
            break;
        }
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private void setSource(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    private void setCookie() {
        this.cookie = Source.COOKIE.getPassportId(this);
    }

    private String getCookie() {
        return this.cookie;
    }

    private void logDebugInfo() {
        if (log.isDebugEnabled()) {
            log.debug("Passport object created for BiBus envelope: ");
            log.debug("  - Passport ID from header: ", this.getPassportIDFromHeader());
            log.debug("  - Passport ID from cookie: ", this.getPassportIDFromCookie());
            log.debug("  - Passport ID from form:   ", this.getPassportIDFromForm());
            log.debug(new Object[]{"  - Source and ID:           ", this.getSource(), ", ", this.getId()});
        }
    }

    private void evaluateRequirements() {
        log.debug("Evaluating requirements");
        this.evaluateRejectionRequired();
        this.evaluateAuthenticationRequired();
        this.evaluateLogonRequired();
    }

    private void evaluateRejectionRequired() {
        this.rejectionRequired = true;
        if (this.hasPassportMismatch) {
            log.debug("Request rejection required: passport mismatch");
        } else if (this.hasSecurityRestriction()) {
            log.debug("Security restrictions prohibit a user from supplying both PassportId and CamAction");
        } else {
            this.rejectionRequired = false;
        }
    }

    private boolean hasSecurityRestriction() {
        return this.hasCAMAction() && this.sourceIsForm() && !this.hasCamSecurityBlob() && !this.hasCamPassword();
    }

    private boolean hasCamSecurityBlob() {
        return this.hasFormValue("CAM_SecurityBlob");
    }

    private boolean hasCamPassword() {
        return this.hasFormValue("CAMPassword");
    }

    private boolean hasFormValue(String name) {
        String value = this.envelope.getFormValue(name);
        return StringUtils.isNotEmpty((String)value);
    }

    private boolean hasCAMAction() {
        return this.envelope.getCAMAction() != null;
    }

    private boolean sourceIsForm() {
        return this.getSource() == Source.FORM;
    }

    private void evaluateAuthenticationRequired() {
        this.authenticationRequired = true;
        if (!this.hasId()) {
            log.debug("Authentication is required because biBus envelope has no passport id.");
        } else if (this.hasCAMAction()) {
            log.debug("Authentication is required because biBus envelope has a CAM Action, ", this.envelope.getCAMAction());
        } else if (this.sourceIsForm()) {
            log.debug("Authentication is required because source is FORM.");
        } else {
            this.authenticationRequired = false;
        }
    }

    private boolean hasId() {
        return this.getId() != null;
    }

    private void evaluateLogonRequired() {
        boolean bl = this.logonRequired = !this.hasId() && !this.hasCAMAction();
        if (this.logonRequired) {
            log.debug("Logon is required");
        }
    }

    private void tryToCopyPassportIdToBiBusHeader() {
        if (this.canCopyPassportIdToBiBusHeader()) {
            this.copyPassportIdToBiBusHeader();
        }
    }

    private boolean canCopyPassportIdToBiBusHeader() {
        boolean canCopy = false;
        if (Passport.hasCompleteCamElement(this.envelope)) {
            log.debug("Passport id is already in a complete CAM element. Not copying it again.");
        } else if (this.isRejectionRequired()) {
            log.debug("Request rejection required, can't copy passport id to the BIBus header.");
        } else if (!this.hasId()) {
            log.debug("No passport id to copy to BIBus header.");
        } else {
            canCopy = true;
        }
        return canCopy;
    }

    private static boolean hasCompleteCamElement(BIBusEnvelope envelope) {
        return envelope.hasCamSettingsElement();
    }

    private boolean hasIncompleteCamElement() {
        if (this.getCam().hasIncompleteCamElement()) {
            log.debug("CAM element is incomplete");
            return true;
        }
        return false;
    }

    public boolean isRejectionRequired() {
        return this.rejectionRequired;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public boolean isLogonRequired() {
        return this.logonRequired;
    }

    private void copyPassportIdToBiBusHeader() {
        Passport.copyPassportIdToBiBusHeader(this.envelope, this.getPassportIdForCamCookieCreation());
        this.clonePassportIfNeeded();
    }

    public static void copyPassportIdToBiBusHeader(BIBusEnvelope envelope, String passportID) {
        envelope.getBiBusHeader().getCam().setCamCookie(passportID);
    }

    private String getPassportIdForCamCookieCreation() {
        return this.hasCookie() ? this.getCookie() : this.getId();
    }

    private boolean hasCookie() {
        return !StringUtils.isEmpty((String)this.getCookie());
    }

    private void clonePassportIfNeeded() {
        if (this.sourceIsForm()) {
            this.envelope.setCAMaction("clonePassport");
        }
    }

    private String getPassportIDFromIncompleteCamElement() {
        return this.hasIncompleteCamElement() ? this.processPassportIDFromIncompleteCamElement() : null;
    }

    private String processPassportIDFromIncompleteCamElement() {
        String passportID = this.envelope.getPassportID();
        CAMCookie cookie = CAMUtils.createCookie(passportID);
        if (Passport.isNewVersionCookie(cookie)) {
            return this.copyCamCookieToIncompleteCamElement(cookie);
        }
        this.detectPassportMismatch(passportID);
        return null;
    }

    private String copyCamCookieToIncompleteCamElement(CAMCookie cookie) {
        log.debug("Incomplete CAM element has a new version cookie used as a passport id. ", "Re-creating CAM element using this cookie.");
        this.getCam().setCamCookie(cookie);
        return cookie.getPassportID();
    }

    private static boolean isNewVersionCookie(CAMCookie cookie) {
        return cookie != null && cookie.getVersion() > 0;
    }

    private void detectPassportMismatch(String incompletePassportId) {
        if (incompletePassportId != null) {
            this.hasPassportMismatch = this.hasPassportMismatch(this.getPassportIDFromCookie(), incompletePassportId) || this.hasPassportMismatch(this.getPassportIDFromForm(), incompletePassportId);
        }
    }

    private boolean hasPassportMismatch(String passportID, String incompletePassportId) {
        CAMCookie camCookie = passportID != null ? CAMUtils.createCookie(passportID) : null;
        String decodedPassport = camCookie != null ? camCookie.getPassportID() : null;
        return decodedPassport != null && !decodedPassport.equals(incompletePassportId);
    }

    private String getPassportIDFromHeader() {
        return this.envelope.getPassportID();
    }

    BIBusEnvelope getEnvelope() {
        return this.envelope;
    }

    private String getPassportIDFromCookie() {
        String passportID = this.envelope.getCookieValue(PASSPORT_COOKIE_NAME);
        return Passport.isQuoted(passportID) ? Passport.getUnquotedValueWithoutAttributes(passportID) : passportID;
    }

    private static boolean isQuoted(String cookieValue) {
        return cookieValue != null && cookieValue.startsWith(DOUBLE_QUOTE);
    }

    private static String getUnquotedValueWithoutAttributes(String cookieValue) {
        log.debug("Unquoting cookie value: ", cookieValue);
        int startPos = cookieValue.indexOf(DOUBLE_QUOTE) + 1;
        int endPos = cookieValue.indexOf(DOUBLE_QUOTE, startPos);
        return endPos > startPos ? cookieValue.substring(startPos, endPos) : cookieValue;
    }

    private String getPassportIDFromForm() {
        return this.envelope.getFormValue(PASSPORT_FORM_NAME);
    }

    public static enum Source {
        COOKIE_IN_CAM_ELEMENT{

            @Override
            public String getPassportId(Passport passport) {
                return passport.getPassportIDFromIncompleteCamElement();
            }
        }
        ,
        HEADER{

            @Override
            public String getPassportId(Passport passport) {
                return passport.getPassportIDFromHeader();
            }
        }
        ,
        COOKIE{

            @Override
            public String getPassportId(Passport passport) {
                return passport.getPassportIDFromCookie();
            }
        }
        ,
        FORM{

            @Override
            public String getPassportId(Passport passport) {
                return passport.getPassportIDFromForm();
            }
        };


        public abstract String getPassportId(Passport var1);
    }
}

