/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.auth;

import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;

public class SetNoCookiesHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();

    public SetNoCookiesHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext messageContext) throws PogoException {
        BIBusEnvelope responseEnvelope = (BIBusEnvelope)messageContext.getProperty("response.envelope");
        this.removeSetCookiesFrom(responseEnvelope);
        this.removeCookiesFrom(messageContext);
    }

    private void removeSetCookiesFrom(BIBusEnvelope responseEnvelope) {
        if (responseEnvelope != null) {
            log.debug("Removing all setCookies from response envelope");
            responseEnvelope.getBiBusHeader().getHdrSession().getSetCookieVars().clear();
        }
    }

    private void removeCookiesFrom(MessageContext messageContext) {
        if (messageContext instanceof MessageContextImpl) {
            log.debug("Removing cookies from message context");
            ((MessageContextImpl)messageContext).clearCookies();
        }
    }
}

