/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import java.util.Enumeration;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Header;
import org.dom4j.Element;

public abstract class BIBusPassThroughCommand
extends BIBusCommand {
    private static final PogoLogger log = PogoLogger.getLogger();
    private BIBusEnvelope passThroughEnvelope;
    private InternetHeaders mimeHeaders;
    private String requestContext = "";

    public BIBusPassThroughCommand(BIBusEnvelope envelope, InternetHeaders headers) {
        this.initialize(envelope, headers);
    }

    public BIBusPassThroughCommand(BIBusEnvelope envelope, InternetHeaders headers, MessageContext mc) {
        super(mc);
        this.initialize(envelope, headers);
    }

    private void initialize(BIBusEnvelope envelope, InternetHeaders headers) {
        this.passThroughEnvelope = envelope;
        this.mimeHeaders = headers;
    }

    @Override
    protected String fetchRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(String context) {
        this.requestContext = context;
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        boolean firstCookie = true;
        Enumeration eHeaders = this.mimeHeaders.getAllHeaders();
        while (eHeaders.hasMoreElements()) {
            javax.mail.Header hdr = (javax.mail.Header)eHeaders.nextElement();
            String headerName = hdr.getName();
            if (headerName.equalsIgnoreCase("content-length") || headerName.equalsIgnoreCase("transfer-encoding") || headerName.equalsIgnoreCase("host") || headerName.equalsIgnoreCase("expect") && hdr.getValue().indexOf("100") != -1 && this.shouldIgnoreExpect100Continue()) continue;
            if (headerName.equalsIgnoreCase("cookie")) {
                if (firstCookie) {
                    connection.setRequestHeader(headerName, hdr.getValue());
                    firstCookie = false;
                    continue;
                }
                connection.addRequestHeader(headerName, hdr.getValue());
                continue;
            }
            connection.setRequestHeader(headerName, hdr.getValue());
        }
    }

    private boolean shouldIgnoreExpect100Continue() {
        return Boolean.valueOf(PropertyInserter.getProperty("expect100Continue", "false")) == false;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return null;
    }

    @Override
    protected void updateRequest() throws CommandExecutionException {
        this.setRequestEvelope(this.passThroughEnvelope);
    }

    @Override
    protected void executeImpl(Element requestElement) throws CommandExecutionException {
    }

    @Override
    protected void handleResponseImpl(Element responseElement) throws CommandExecutionException {
    }

    @Override
    protected void addExtraSOAPHeaders() {
    }

    @Override
    protected void handleResponseMIMEHeaders(Header[] headers) {
        int size = headers.length;
        for (int i = 0; i < size; ++i) {
            this.responseMimeHeaders.addHeader(headers[i].getName(), headers[i].getValue());
        }
    }
}

