/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

import com.cognos.pogo.util.PogoLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStreamSpy
extends BufferedOutputStream {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ByteArrayOutputStream spyBuffer;

    public BufferedOutputStreamSpy(OutputStream out) {
        super(out);
        if (log.isDebugEnabled()) {
            this.spyBuffer = new ByteArrayOutputStream();
        }
    }

    public BufferedOutputStreamSpy(OutputStream output, int bufferSize) {
        super(output, bufferSize);
        if (log.isDebugEnabled()) {
            this.spyBuffer = new ByteArrayOutputStream(bufferSize);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.spyBuffer != null) {
            this.spyBuffer.write(b, off, len);
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        super.write(b);
        if (this.spyBuffer != null) {
            this.spyBuffer.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        if (this.spyBuffer != null) {
            this.spyBuffer.write(b);
        }
    }

    public void dumpToLog(Object owner) {
        log.debug("Output content generated by ", owner.getClass().getSimpleName(), ": ", this.spyBuffer);
    }
}

