/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.DSServiceAccessSession;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.cognos.pogo.bibus.Crypto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class CryptoFacility
implements Crypto {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CryptoFacility.class.getName());
    static final Logger catDetail = Hierarchy.getDefaultHierarchy().getLoggerFor(CryptoFacility.class.getName() + ".detail");
    private static final byte[] INITDOC_PREFIX = "<initializeDocument><serviceID>".getBytes();
    private static final byte[] INITDOC_SUFFIX = "</serviceID></initializeDocument>".getBytes();
    private static final String DEFAULT_SERVICE_ID = "DISP";
    private static final Map<String, TrustedRequestSession> trusterMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, SigningSession> signerMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, CAMFactory> camFactoryMap = Collections.synchronizedMap(new HashMap());
    private static int seq = 0;

    private static TrustedRequestSession createTrustedSession(String serviceID) throws CAMCryptoException {
        return CryptoFacility.createCAMFactory(serviceID).createTrustedSession();
    }

    private static SigningSession createSigningSession(String serviceID) throws CAMCryptoException {
        return CryptoFacility.createCAMFactory(serviceID).createSigningSession();
    }

    private static CAMFactory createCAMFactory(String serviceID) throws CAMCryptoException {
        byte[] serviceIDBytes = serviceID.getBytes();
        byte[] initDoc = new byte[INITDOC_PREFIX.length + serviceIDBytes.length + INITDOC_SUFFIX.length];
        System.arraycopy(INITDOC_PREFIX, 0, initDoc, 0, INITDOC_PREFIX.length);
        System.arraycopy(serviceIDBytes, 0, initDoc, INITDOC_PREFIX.length, serviceIDBytes.length);
        System.arraycopy(INITDOC_SUFFIX, 0, initDoc, INITDOC_PREFIX.length + serviceIDBytes.length, INITDOC_SUFFIX.length);
        CAMFactory camFactory = new CAMFactory();
        camFactory.initialize(initDoc);
        return camFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustedRequestSession fetchTrustedSession(String serviceID) throws CAMCryptoException {
        Map<String, TrustedRequestSession> map = trusterMap;
        synchronized (map) {
            TrustedRequestSession session = trusterMap.get(serviceID);
            if (session == null) {
                session = CryptoFacility.createTrustedSession(serviceID);
                trusterMap.put(serviceID, session);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] signRequest(byte[] requestBytes, String serviceID) throws Exception {
        TrustedRequestSession trustSession;
        TrustedRequestSession trustedRequestSession = trustSession = CryptoFacility.fetchTrustedSession(serviceID);
        synchronized (trustedRequestSession) {
            if (catDetail.isDebugEnabled()) {
                byte[] signed = trustSession.setMessageTrust(serviceID, requestBytes);
                if (trustSession.isTrusted(signed)) {
                    catDetail.debug("verified trusted signature is OK .");
                    CryptoFacility.logSignedRequest(signed);
                } else {
                    catDetail.debug("!!!!!! signature is bad !!!!.");
                }
                return signed;
            }
            return trustSession.setMessageTrust(serviceID, requestBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testSigned(byte[] msg) throws CAMCryptoException {
        TrustedRequestSession truster;
        TrustedRequestSession trustedRequestSession = truster = CryptoFacility.fetchTrustedSession(DEFAULT_SERVICE_ID);
        synchronized (trustedRequestSession) {
            return truster.isTrusted(msg);
        }
    }

    private static void logSignedRequest(byte[] signed) {
        try {
            File signedDirectory = new File("signed");
            signedDirectory.mkdir();
            File aFile = new File(signedDirectory, "signedRequest" + seq++ + ".xml");
            aFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(aFile);
            fos.write(signed);
            fos.close();
        }
        catch (IOException x) {
            cat.debug("failed to save signed request bytes.", (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SigningSession fetchSigningSession(String serviceID) throws CAMCryptoException {
        Map<String, SigningSession> map = signerMap;
        synchronized (map) {
            SigningSession session = signerMap.get(serviceID);
            if (session == null) {
                session = CryptoFacility.createSigningSession(serviceID);
                signerMap.put(serviceID, session);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateHash(byte[] data, String serviceID) throws CAMCryptoException {
        SigningSession session;
        if (serviceID == null) {
            serviceID = DEFAULT_SERVICE_ID;
        }
        SigningSession signingSession = session = CryptoFacility.fetchSigningSession(serviceID);
        synchronized (signingSession) {
            return session.hash(data);
        }
    }

    public static CAMFactory getCAMFactory() throws CAMCryptoException {
        return CryptoFacility.getCAMFactory(DEFAULT_SERVICE_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAMFactory getCAMFactory(String serviceID) throws CAMCryptoException {
        if (serviceID == null) {
            serviceID = DEFAULT_SERVICE_ID;
        }
        Map<String, CAMFactory> map = camFactoryMap;
        synchronized (map) {
            CAMFactory factory = camFactoryMap.get(serviceID);
            if (factory == null) {
                factory = CryptoFacility.createCAMFactory(serviceID);
                camFactoryMap.put(serviceID, factory);
            }
            return factory;
        }
    }

    public static boolean hasCAMFactory(String serviceID) {
        return camFactoryMap.containsKey(serviceID);
    }

    @Override
    public CAMFactory getCamFactory() throws CAMCryptoException {
        return CryptoFacility.getCAMFactory();
    }

    @Override
    public UserSessionIDSession createUserSessionIDSession() throws CAMCryptoException {
        return new UserSessionIDSession();
    }

    @Override
    public byte[] signTrustedRequest(byte[] requestBytes, String serviceID) throws Exception {
        return CryptoFacility.signRequest(requestBytes, serviceID);
    }

    public boolean isContentSigned(byte[] msg) throws CAMCryptoException {
        return CryptoFacility.testSigned(msg);
    }

    @Override
    public byte[] decryptData(byte[] encryptedBytes) throws CAMCryptoException {
        EncryptingSession encryptingSession = this.getCamFactory().createEncryptingSession();
        return encryptingSession.decryptData(encryptedBytes);
    }

    @Override
    public byte[] getToken(byte[] bytes) throws CAMCryptoException {
        DSServiceAccessSession session = new DSServiceAccessSession();
        return session.getToken(bytes);
    }
}

