/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.bibus.passthrough;

import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.bibus.passthrough.ActiveDispatcherPassThroughCommand;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.contentmanager.coordinator.CMUri;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Element;

public class ActiveDispatcherInterceptHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String REQUEST_SOAPACTION = "request.soapaction";
    private NodeID activeDispatcherNodeID;
    private DispatcherServices dispatcherServices;
    private HashMap<String, Handler> interceptHandlers = new HashMap();

    public ActiveDispatcherInterceptHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void configure(Configuration configuration) {
        NodeID cmNodeID = NodeIdGuidMapper.getContentManagerNID();
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        for (DispatcherListElement dle : dispatcherList.getDispatcherListElements()) {
            if (!cmNodeID.isSameDispatcher(dle.getNodeID())) continue;
            this.activeDispatcherNodeID = dle.getNodeID();
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.activeCMIsLocal()) {
            this.forwardRequest(mc);
        } else {
            this.sendRequestToActive(mc);
        }
    }

    private boolean activeCMIsLocal() {
        return CMUri.isActiveCMLocal();
    }

    private void forwardRequest(MessageContext mc) throws PogoException {
        log.debug("ActiveDispatcher request is local");
        String soapAction = this.getSoapAction(mc);
        Handler handler = this.getInterceptedHandler(soapAction);
        if (handler == null) {
            this.setFault(mc, soapAction);
        } else {
            mc.setProperty(REQUEST_SOAPACTION, soapAction);
            handler.invoke(mc);
        }
    }

    Handler getInterceptedHandler(String soapAction) {
        Handler handler = this.interceptHandlers.get(soapAction);
        return handler;
    }

    private void setFault(MessageContext mc, String soapAction) {
        log.error("SOAPAction ", soapAction, " is not handled by ActiveDispatcherInterceptHandler");
        Fault f = new Fault("UNKNOWN_SERVICE");
        f.setMessageParameters(new Object[]{soapAction});
        mc.setFault(f);
    }

    private void sendRequestToActive(MessageContext mc) throws PogoException {
        log.debug("ActiveDispatcher request forwarded to: ", this.activeDispatcherNodeID);
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        BIBusCommand command = this.createPassThroughCommand(headers, envelope);
        try {
            command.execute();
        }
        catch (SoapFaultException sfex) {
            mc.setFault(new Fault("", command.getResponseEnvelope()));
        }
        catch (CommandExecutionException e) {
            log.error("Exception caught while trying to relay a request to active CM dispatcher", e);
        }
        mc.setResponseName("response");
        mc.setProperty("response.envelope", command.getResponseEnvelope());
        mc.setProperty("response.headers", command.getResponseMIMEHeaders());
        mc.setProperty("response.status_code", Integer.toString(command.getStatusCode()));
        try {
            mc.respond("response");
        }
        catch (IOException e) {
            throw new PogoException("Exception responding", e);
        }
    }

    protected BIBusCommand createPassThroughCommand(InternetHeaders headers, BIBusEnvelope envelope) {
        return new ActiveDispatcherPassThroughCommand(envelope, headers, this.activeDispatcherNodeID);
    }

    @Override
    public void initialize() {
        this.dispatcherServices = this.getPogoEngine().getDispatcherServices();
        Element interceptElements = this.getConfig().element("intercepts");
        this.processIntercepts(interceptElements);
    }

    protected void processIntercepts(Element interceptElements) {
        List elements = interceptElements.elements("soapAction");
        for (Element soapActionElement : elements) {
            String soapAction = soapActionElement.getTextTrim();
            this.transferHandlersForSoapAction(soapAction);
        }
    }

    private void transferHandlersForSoapAction(String soapAction) {
        log.debug("intercepting soapAction: ", soapAction);
        Handler handler = this.interceptSoapAction(soapAction);
        ArrayList<String> expandedSoapActions = this.dispatcherServices.changeHandlerForPath(soapAction, this);
        if (handler != null) {
            for (String expandedSoapAction : expandedSoapActions) {
                this.interceptHandlers.put(expandedSoapAction, handler);
            }
        }
    }

    private Handler interceptSoapAction(String soapAction) {
        Handler localHandler = this.dispatcherServices.lookupHandler(soapAction);
        if (localHandler != null) {
            log.debug("intercepted soapAction: ", soapAction, " Local handler is ", localHandler);
            this.interceptHandlers.put(soapAction, localHandler);
        }
        return localHandler;
    }

    private String getSoapAction(MessageContext mc) {
        return mc.getStrProperty(REQUEST_SOAPACTION);
    }
}

