/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.capacity;

import com.cognos.pogo.capacity.ServiceCapacity;
import com.cognos.pogo.capacity.ServiceCapacityObserver;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.List;

public class ServiceCapacityMediator {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static ServiceCapacityMediator instance;
    private List<ServiceCapacityObserver> observerList = new ArrayList<ServiceCapacityObserver>();

    private ServiceCapacityMediator() {
    }

    public static synchronized ServiceCapacityMediator getInstance() {
        if (instance == null) {
            instance = new ServiceCapacityMediator();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ServiceCapacityObserver obs) {
        List<ServiceCapacityObserver> list = this.observerList;
        synchronized (list) {
            this.observerList.add(obs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ServiceCapacityObserver obs) {
        List<ServiceCapacityObserver> list = this.observerList;
        synchronized (list) {
            this.observerList.remove(obs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ServiceCapacity newCapacity) {
        log.debug("Service Capacity notification: ", newCapacity);
        List<ServiceCapacityObserver> list = this.observerList;
        synchronized (list) {
            for (ServiceCapacityObserver obs : this.observerList) {
                obs.update(newCapacity);
            }
        }
    }
}

