/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.BIBusResponse;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.handlers.configurable.HandoffAdminCommand;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.pogo.util.DomUtils;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public abstract class AdminCommand {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(AdminCommand.class.getName());
    private Element commandElement;
    MessageContext messageContext;
    protected DispatcherNameParser nameParser;
    protected String soapAction;

    public AdminCommand(Element e, MessageContext mc) {
        this.commandElement = e;
        this.messageContext = mc;
        this.setNeedToUpdateDispatcherStatus("false");
    }

    public abstract boolean executeImpl(BIBusResponse var1);

    public void execute() {
        String statusString;
        String statusCode;
        boolean success;
        BIBusResponse response;
        block9: {
            response = new BIBusResponse();
            BIBusEnvelope env = (BIBusEnvelope)this.messageContext.getProperty("request.envelope");
            this.soapAction = (String)this.messageContext.getProperty("request.soapaction");
            try {
                if (!this.isSameDispatcher(this.getNameParser())) {
                    try {
                        this.handoffRequest(env, response, this.getCommandElement());
                    }
                    catch (SoapFaultException ex) {
                        Fault f = new Fault("AdminCommand.requestFailed", ex);
                        String detailFaultMsg = ex.getFault().valueOf("//@errorCodeString");
                        if (detailFaultMsg != null) {
                            f.setDetailMessasge(detailFaultMsg);
                        }
                        this.messageContext.setFault(f);
                        return;
                    }
                    catch (Exception ex) {
                        this.messageContext.setFault(new Fault("AdminCommand.handoffFailed", ex));
                        return;
                    }
                    success = true;
                    break block9;
                }
                env.copyBiBusHeaderTo(response.getResponseEnvelope());
                success = this.executeImpl(response);
            }
            catch (Exception ex) {
                this.messageContext.setFault(new Fault("AdminCommand.requestFailed", ex));
                return;
            }
        }
        if (success) {
            statusCode = "200";
            statusString = "OK";
            cat.debug("response = " + response);
        } else {
            statusCode = "500";
            statusString = "Internal Server Error";
        }
        InternetHeaders responseHeaders = new InternetHeaders();
        responseHeaders.addHeader("Content-Type", "text/xml; charset=utf-8");
        this.messageContext.setProperty("response.status_code", statusCode);
        this.messageContext.setProperty("response.status_msg", statusString);
        this.messageContext.setProperty("response.headers", responseHeaders);
        this.messageContext.setProperty("response.envelope", response.getResponseEnvelope(this.getResponseName()));
    }

    abstract DispatcherNameParser getNameParser() throws Exception;

    abstract String getResponseName();

    protected boolean isSameDispatcher(DispatcherNameParser parser) throws PogoException, UnknownHostException {
        this.nameParser = parser;
        String parserHost = parser.getHost();
        int parserPort = parser.getPort();
        String parserPath = parser.getRequestPath();
        if (parserHost == null || parserPath == null) {
            cat.error("Unable to obtain host or path from objectPath");
            throw new PogoException("Unable to obtain host or path from objectPath");
        }
        NodeID parserNid = NodeID.getNodeID(parserHost, parserPort, parserPath);
        if (!parserNid.resolveHostInetAddress()) {
            throw new UnknownHostException();
        }
        return parserNid.isLocalToSelf();
    }

    protected void handoffRequest(BIBusEnvelope originalRequest, BIBusResponse response, Element commandElement) throws Exception {
        HandoffAdminCommand handoff = new HandoffAdminCommand(commandElement, this.getNameParser(), this.soapAction);
        BIBusEnvelope commandRequestEnvelope = handoff.getRequestEnvelope();
        originalRequest.transferHeaderTo(commandRequestEnvelope);
        try {
            handoff.execute();
            Element handoff_resp = handoff.getResponseElement();
            this.copyResponseElements(response, handoff_resp);
        }
        catch (Exception ex) {
            BIBusEnvelope responseEnvelope = handoff.getResponseEnvelope();
            if (responseEnvelope != null) {
                Element faultElement = this.getFault(responseEnvelope);
                if (faultElement != null) {
                    response.addFault(faultElement);
                } else {
                    response.addFault(ex);
                }
            } else {
                response.addFault(ex);
            }
            throw ex;
        }
        finally {
            BIBusEnvelope anEnvelope = handoff.getResponseEnvelope();
            if (anEnvelope == null) {
                anEnvelope = handoff.getRequestEnvelope();
            }
            anEnvelope.getHeader();
            anEnvelope.transferHeaderTo(response.getResponseEnvelope());
        }
    }

    private Element getFault(BIBusEnvelope responseEnvelope) {
        return responseEnvelope.getFault();
    }

    private void copyResponseElements(BIBusResponse response, Element handoff_resp) {
        for (Element element : this.getResponseElements(handoff_resp)) {
            element.detach();
            response.addResponse(element);
        }
    }

    private List<Element> getResponseElements(Element handoff_resp) {
        return DomUtils.selectElements(handoff_resp, this.getResponsePath());
    }

    private String getResponsePath() {
        StringBuffer responsePath = new StringBuffer("./*[local-name()='");
        responsePath.append(this.getResponseName());
        responsePath.append("']/*");
        return responsePath.toString();
    }

    void setCommandElement(Element commandElement) {
        this.commandElement = commandElement;
    }

    Element getCommandElement() {
        return this.commandElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkServiceWithCM(String servicePath) {
        ContentManagerQueryCommand cmd = new ContentManagerQueryCommand(servicePath);
        BIBusEnvelope env = (BIBusEnvelope)this.messageContext.getProperty("request.envelope");
        BIBusEnvelopeUtils.moveAuthenticatedHeaderFromOriginalRequest(cmd, env);
        cmd.addQueryPropertyName("permissions");
        try {
            cmd.execute();
        }
        catch (SoapFaultException ex) {
            cat.debug("Soap Fault checking service with CM : " + ex.getFault().asXML(), (Throwable)ex);
        }
        catch (CommandExecutionException e) {
            cat.debug("CommandExecutionException on communication with CM", (Throwable)e);
        }
        finally {
            BIBusEnvelope envelope = cmd.getResponseEnvelope();
            if (envelope == null) {
                envelope = cmd.getRequestEnvelope();
            }
            envelope.transferHeaderTo(env);
        }
        Element resp = cmd.getQueryResponseElement();
        if (resp == null) {
            return false;
        }
        return this.hasWritePermissionValue(resp);
    }

    private boolean hasWritePermissionValue(Element resp) {
        for (Element item : this.getPermissionValueItems(resp)) {
            if (!item.getTextTrim().equalsIgnoreCase("write")) continue;
            return true;
        }
        return false;
    }

    private List<Element> getPermissionValueItems(Element resp) {
        return DomUtils.selectElements(resp, "//permissions/value/item");
    }

    protected void setNeedToUpdateDispatcherStatus(String status) {
        this.messageContext.setProperty("dispatcher.updateStatus", status);
    }

    String formatExceptionMessage(String messageKey, Exception e) {
        DispatcherStrings strings = DispatcherStrings.getInstance();
        Locale locale = (Locale)this.messageContext.getProperty("locale");
        if (e == null) {
            return strings.getString(messageKey, locale);
        }
        Object[] params = new Object[]{e.getMessage()};
        return strings.getString(messageKey, locale, params);
    }
}

