/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.pogo.config.AdminCommand;
import com.cognos.pogo.config.DispatcherNameParser;
import com.cognos.pogo.config.ServiceNameParser;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Service;
import org.dom4j.Element;

public abstract class ServiceAdminCommand
extends AdminCommand {
    protected PogoEngine pogoEngine;

    public ServiceAdminCommand(Element e, MessageContext mc, PogoEngine engine) {
        super(e, mc);
        this.pogoEngine = engine;
    }

    @Override
    protected DispatcherNameParser getNameParser() throws Exception {
        if (this.nameParser == null) {
            Element serviceElement = this.getServiceElement();
            String servicePath = serviceElement.getText();
            this.nameParser = new ServiceNameParser(servicePath);
        }
        return this.nameParser;
    }

    Element getServiceElement() {
        Element serviceElement = this.getServicePathElement();
        return serviceElement != null ? serviceElement : this.getDeprecatedServiceElement();
    }

    Element getServicePathElement() {
        return this.getCommandElement().element("servicePath");
    }

    Element getDeprecatedServiceElement() {
        return this.getCommandElement().element("service");
    }

    protected Service getService(String serviceName) throws PogoException {
        Service service = this.pogoEngine.getDispatcherServices().getService(serviceName);
        if (service == null) {
            String msg = DispatcherStrings.getInstance().getString("UNKNOWN_SERVICE", new Object[]{serviceName});
            throw new PogoException(msg);
        }
        return service;
    }

    public void parseResponse(Element requestElement) throws Exception {
        this.getNameParser().parseResult(requestElement);
    }
}

