/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.config;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.InvalidServiceException;
import com.cognos.pogo.pdk.PogoConfigException;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.ServiceFactory;
import com.cognos.pogo.transport.ServletEngineContext;
import com.cognos.pogo.util.PogoIPFLog;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class XMLConfigurator {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ClassLoader classLoader;

    public XMLConfigurator() {
        this(null);
    }

    public XMLConfigurator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void configure(PogoEngine engine, ServletConfig config) {
        if (ServletEngineContext.isCanUseResourcePaths()) {
            log.debug("Loading XML service files using the classloader");
            this.configureFromResources(engine, config);
        } else {
            log.debug("Loading XML service files using the filesystem");
            this.configureFromFiles(engine, config);
        }
    }

    private void configureFromResources(PogoEngine engine, ServletConfig config) {
        String xmlFolder = config.getInitParameter("com.cognos.pogo.xml.folder");
        ServletContext context = config.getServletContext();
        Set<String> resources = this.getResourcePaths(context, xmlFolder);
        log.debug("The servlet container returned ", resources.size(), " matching resource paths");
        for (String resourcePath : resources) {
            log.debug("Examining ", resourcePath);
            if (!resourcePath.endsWith(".xml")) {
                log.debug(resourcePath, " is not an expected service file... skipping");
                continue;
            }
            if (!resourcePath.startsWith(xmlFolder)) {
                resourcePath = xmlFolder + resourcePath;
            }
            log.debug("Processing services resource: ", resourcePath);
            InputStream resourceStream = context.getResourceAsStream(resourcePath);
            try {
                this.configureFile(engine, resourceStream, resourcePath);
            }
            catch (PogoConfigException e) {
                log.error("failure while configuring ", resourcePath);
                Object[] args = new Object[]{resourcePath, e.getMessage()};
                String errorMsg = DispatcherStrings.getInstance().getString("XMLConfigurator.fileError", args);
                PogoIPFLog.getInstance().logStartupError(errorMsg);
            }
        }
        log.debug("Finished loading services using the classloader");
    }

    private Set<String> getResourcePaths(ServletContext context, String xmlFolder) {
        return context.getResourcePaths(xmlFolder);
    }

    private void configureFromFiles(PogoEngine engine, ServletConfig config) {
        String xmlFolder = config.getInitParameter("com.cognos.pogo.xml.folder");
        String servicesPath = config.getServletContext().getRealPath(xmlFolder);
        File servicesDir = new File(servicesPath);
        File[] serviceList = servicesDir.listFiles();
        for (int i = 0; i < serviceList.length; ++i) {
            String errorMsg;
            Object[] args;
            File file = serviceList[i];
            String fileName = file.getName();
            if (!fileName.endsWith(".xml")) continue;
            log.debug("Processing services file: ", fileName);
            try {
                FileInputStream is = new FileInputStream(file);
                this.configureFile(engine, is, file.toString());
                continue;
            }
            catch (PogoConfigException e) {
                log.error("failure while configuring ", fileName);
                args = new Object[]{file, e.getMessage()};
                errorMsg = DispatcherStrings.getInstance().getString("XMLConfigurator.fileError", args);
                PogoIPFLog.getInstance().logStartupError(errorMsg);
                continue;
            }
            catch (FileNotFoundException e) {
                log.error("Unable to open config file ", file);
                args = new Object[]{file};
                errorMsg = DispatcherStrings.getInstance().getString("XMLConfigurator.fileNotFound", args);
                PogoIPFLog.getInstance().logStartupError(errorMsg);
            }
        }
        log.debug("Finished loading services using the filesystem");
    }

    public Service configureFile(PogoEngine engine, InputStream is, String path) throws PogoConfigException {
        Document doc;
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException e) {
            log.fatalError("Unable to set disallow-doctype-decl on SAXReader", e);
            Object[] args = new Object[]{path};
            String errorMsg = DispatcherStrings.getInstance().getString("XMLConfigurator.parseError", args);
            throw new PogoConfigException(errorMsg, e);
        }
        try {
            doc = reader.read(is);
        }
        catch (DocumentException e) {
            Object[] args = new Object[]{path};
            String errorMsg = DispatcherStrings.getInstance().getString("XMLConfigurator.parseError", args);
            throw new PogoConfigException(errorMsg);
        }
        Element e = doc.getRootElement();
        try {
            Service service = null;
            String elementName = e.getName();
            if ("service".equalsIgnoreCase(elementName)) {
                service = this.configureService(e, engine);
            }
            this.configureServiceAvailability(e, engine);
            return service;
        }
        catch (InvalidServiceException ex) {
            log.warn("Error while processing service xml file " + path, ex);
            return null;
        }
    }

    private Service configureService(Element serviceRootElement, PogoEngine engine) throws PogoConfigException, InvalidServiceException {
        PropertyInserter.insertProperties(serviceRootElement);
        Service service = ServiceFactory.create(serviceRootElement, this.classLoader);
        HandlerPool pool = service.contextualize(serviceRootElement);
        engine.getDispatcherServices().add(service);
        engine.addHandlerPool(service.getName(), pool);
        return service;
    }

    private void configureServiceAvailability(Element serviceElement, PogoEngine engine) {
        String registerInCMValue = serviceElement.attributeValue("registerInCM");
        if (registerInCMValue == null || registerInCMValue.length() == 0) {
            return;
        }
        if (!"true".equalsIgnoreCase(registerInCMValue)) {
            return;
        }
        String serviceName = serviceElement.attributeValue("name");
        if (serviceName == null || serviceName.length() == 0) {
            return;
        }
        log.debug(serviceName, " to be added as an installedComponent");
        engine.addInstalledComponent(serviceName);
    }
}

