/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameters;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ContentManagerAddCommand
extends ContentManagerCommand {
    protected static final QName BUS_ADD = new QName("add", BUS_NAMESPACE);
    protected static final QName BUS_OBJECTS = new QName("objects", BUS_NAMESPACE);
    private static final QName BUS_ADDRESPONSE = new QName("addResponse", BUS_NAMESPACE);
    private static final QName BUS_PROP_defaultName = new QName("defaultName", BUS_NAMESPACE);
    private static final QName BUS_PROP_searchPath = new QName("searchPath", BUS_NAMESPACE);
    private static final QName BUS_PROP_dispatcherPath = new QName("dispatcherPath", BUS_NAMESPACE);
    private static final QName BUS_PROP_state = new QName("state", BUS_NAMESPACE);
    private static final QName BUS_PROP_value = new QName("value", BUS_NAMESPACE);
    private static final QName BUS_PROP_runningState = new QName("runningState", BUS_NAMESPACE);
    private static final QName BUS_PROP_edition = new QName("edition", BUS_NAMESPACE);
    private static final QName BUS_PROP_serverGroup = new QName("serverGroup", BUS_NAMESPACE);
    private static final QName BUS_COMPONENTID = new QName("componentID", BUS_NAMESPACE);
    private Collection<Element> objectElements = new ArrayList<Element>();
    private Element currentObject;
    private int addCount = 0;
    private String search;
    private String updateAction;
    private Element addResponse;
    private List<String> requestedProperties = new ArrayList<String>();

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        this.addCount = 0;
        Element addElement = bodyElement.addElement(BUS_ADD);
        Element searchElement = addElement.addElement("search");
        searchElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        searchElement.addText(this.getSearch());
        Element objectsElement = addElement.addElement("objects");
        objectsElement.addAttribute(SOAPEnvelope.XSI_TYPE, "SOAP-ENC:Array");
        objectsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[]");
        Iterator<Element> it = this.objectElements.iterator();
        while (it.hasNext()) {
            objectsElement.add(it.next());
        }
        this.objectElements.clear();
        this.currentObject = null;
        if (this.updateAction != null || !this.requestedProperties.isEmpty()) {
            this.addUpdateAction(addElement);
        }
        this.addSessionRequestIds("add");
    }

    private void addUpdateAction(Element addElement) {
        Element optionsElement = addElement.addElement("options");
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, "addOptions");
        if (this.updateAction != null) {
            Element updateActionElement = optionsElement.addElement("updateAction");
            updateActionElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":updateActionEnum");
            updateActionElement.addText(this.updateAction);
        }
        if (!this.requestedProperties.isEmpty()) {
            Element rpElement = optionsElement.addElement("returnProperties");
            rpElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            rpElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[]");
            for (String property : this.requestedProperties) {
                Element propItem = rpElement.addElement("item");
                propItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
                propItem.setText(property);
            }
        }
    }

    public void addObject(String type) {
        this.currentObject = DocumentHelper.createElement((String)"item");
        this.currentObject.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + type);
        this.objectElements.add(this.currentObject);
    }

    public void setDefaultName(String defName) {
        Element def = this.currentObject.addElement(BUS_PROP_defaultName);
        def.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":tokenProp");
        def.addElement(BUS_PROP_value).addText(defName);
    }

    public void setSearchPath(String searchPath) {
        this.addStringProperty(BUS_PROP_searchPath, searchPath);
    }

    private void addStringProperty(QName name, String value) {
        Element sp = this.currentObject.addElement(name);
        sp.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":StringProp");
        sp.addElement(BUS_PROP_value).addText(value);
    }

    public void setDispatcherPath(String dispatcherPath) {
        Element def = this.currentObject.addElement(BUS_PROP_dispatcherPath);
        def.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":anyURIProp");
        def.addElement(BUS_PROP_value).addText(dispatcherPath);
    }

    public void setState(String state) {
        Element st = this.currentObject.addElement(BUS_PROP_state);
        st.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":anyTypeProp");
        st.addElement(BUS_PROP_value).addText(state);
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        this.addResponse = bodyElement.element(BUS_ADDRESPONSE);
    }

    public int getNumObjectsaddd() throws CommandExecutionException {
        return this.addCount;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public void setRunningState(String state) {
        Element st = this.currentObject.addElement(BUS_PROP_runningState);
        st.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":runningStateEnumProp");
        st.addElement(BUS_PROP_value).addText(state);
    }

    private String getSearch() {
        return this.search;
    }

    public void setUpdateAction(String action) {
        this.updateAction = action;
    }

    public void addRequestedProperty(String string) {
        this.requestedProperties.add(string);
    }

    public void setComponentID(String serviceName) {
        Element componentIDElement = this.currentObject.addElement(BUS_COMPONENTID);
        componentIDElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":installedComponentEnumProp");
        Element valueElement = componentIDElement.addElement(BUS_PROP_value);
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":installedComponentEnum");
        valueElement.setText(serviceName);
    }

    public String getResponseSearchPath() {
        Element value = (Element)this.addResponse.selectSingleNode("//searchPath/value");
        if (value == null) {
            return null;
        }
        return value.getTextTrim();
    }

    public Element getAddResponse() {
        return this.addResponse;
    }

    public void setSystemMetricThresholds(String metricName, ThresholdParameters thresholdParameters) {
        Element element = this.currentObject;
        thresholdParameters.addSystemMetricProperties(element);
    }

    public void setEdition(String versionStr) {
        this.addStringProperty(BUS_PROP_edition, versionStr);
    }

    public void setServerGroup(String serverGroupStr) {
        this.addStringProperty(BUS_PROP_serverGroup, serverGroupStr);
    }
}

