/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.ArrayList;
import java.util.Collection;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ContentManagerDeleteCommand
extends ContentManagerCommand {
    protected static final QName BUS_DELETE = new QName("delete", BUS_NAMESPACE);
    protected static final QName BUS_OBJECTS = new QName("objects", BUS_NAMESPACE);
    private static final QName BUS_DELETERESPONSE = new QName("deleteResponse", BUS_NAMESPACE);
    private static final QName BUS_PROP_defaultName = new QName("defaultName", BUS_NAMESPACE);
    private static final QName BUS_PROP_searchPath = new QName("searchPath", BUS_NAMESPACE);
    private static final QName BUS_PROP_value = new QName("value", BUS_NAMESPACE);
    private Collection<Element> objectElements = new ArrayList<Element>();
    private Element currentObject;
    private int deleteCount;
    private boolean recursive;
    private boolean force;

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        this.deleteCount = 0;
        Element deleteElement = bodyElement.addElement(BUS_DELETE);
        Element objectsElement = deleteElement.addElement("objects");
        objectsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        objectsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[]");
        for (Element element : this.objectElements) {
            objectsElement.add(element);
        }
        this.objectElements.clear();
        this.currentObject = null;
        this.addOptions(deleteElement);
        this.addSessionRequestIds("runtimeInfo");
    }

    private void addOptions(Element deleteElement) {
        if (this.recursive || this.force) {
            Element optionsElement = deleteElement.addElement("options");
            if (this.recursive) {
                Element recurseElement = optionsElement.addElement("recursive");
                recurseElement.setText("true");
            }
            if (this.force) {
                Element forceElement = optionsElement.addElement("force");
                forceElement.setText("true");
            }
        }
    }

    public void addObject(String type) {
        this.currentObject = DocumentHelper.createElement((String)"item");
        this.currentObject.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + type);
        this.objectElements.add(this.currentObject);
    }

    public void setDefaultName(String defName) {
        Element def = this.currentObject.addElement(BUS_PROP_defaultName);
        def.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":tokenProp");
        def.addElement(BUS_PROP_value).addText(defName);
    }

    public void setSearchPath(String searchPath) {
        Element sp = this.currentObject.addElement(BUS_PROP_searchPath);
        sp.addAttribute(SOAPEnvelope.XSI_TYPE, "bus:StringProp");
        sp.addElement(BUS_PROP_value).addText(searchPath);
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        Element deleteResponse = bodyElement.element(BUS_DELETERESPONSE);
        this.deleteCount = 0;
        try {
            this.deleteCount = Integer.parseInt(deleteResponse.elementText("count"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getNumObjectsDeleted() throws CommandExecutionException {
        return this.deleteCount;
    }
}

