/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ContentManagerQueryCommand
extends ContentManagerCommand {
    protected static final QName BUS_QUERY = new QName("query", BUS_NAMESPACE);
    private static final QName BUS_QUERYRESPONSE = new QName("queryResponse", BUS_NAMESPACE);
    private static final String MIME_DATA_ENCODING = "MIME";
    private static final String MIME_COMPRESSED_DATA_ENCODING = "MIMECompressed";
    private String queryObjectName;
    private Collection<String> propertyElements = new HashSet<String>();
    private Collection<String> parentPropertyElements = new HashSet<String>();
    private List<CMClass> resultList;
    private Element queryResponse;
    private String mimeDataEncoding;
    private String refPropName;
    private String permission;

    public ContentManagerQueryCommand(String queryObjectName) {
        this(queryObjectName, null);
    }

    public ContentManagerQueryCommand(String queryObjectName, MessageContext mc) {
        super(mc);
        this.setQueryObject(queryObjectName);
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element queryElement = bodyElement.addElement(BUS_QUERY);
        this.addSessionRequestIds("query");
        this.addSearchElements(queryElement);
    }

    protected void addSearchElements(Element queryElement) {
        Element searchElement = queryElement.addElement("search");
        searchElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        searchElement.setText(this.queryObjectName);
        Element propertiesElement = queryElement.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        for (String propertyName : this.propertyElements) {
            Element itemElement = DocumentHelper.createElement((String)"item");
            itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            itemElement.setText(propertyName);
            propertiesElement.add(itemElement);
        }
        propertiesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[" + this.propertyElements.size() + "]");
        Element sortByElement = queryElement.addElement("sortBy");
        sortByElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        Element optionsElement = queryElement.addElement("options");
        if (this.addOptions(optionsElement)) {
            optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":queryOptions");
        } else {
            optionsElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
    }

    private boolean addOptions(Element optionsElement) {
        boolean added = false;
        if (this.addDataEncoding(optionsElement)) {
            added = true;
        }
        if (this.addRefProps(optionsElement)) {
            added = true;
        }
        if (this.addPermission(optionsElement)) {
            added = true;
        }
        return added;
    }

    private boolean addDataEncoding(Element optionsElement) {
        if (this.mimeDataEncoding == null) {
            return false;
        }
        Element dataEncodingElement = optionsElement.addElement("dataEncoding");
        dataEncodingElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":encodingEnum");
        dataEncodingElement.setText(this.mimeDataEncoding);
        return true;
    }

    private boolean addRefProps(Element optionsElement) {
        if (this.parentPropertyElements.isEmpty()) {
            return false;
        }
        Element refPropsElement = optionsElement.addElement("refProps");
        refPropsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        Element refPropsItem = refPropsElement.addElement("item");
        refPropsItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":refProp");
        Element propertiesElement = refPropsItem.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        for (String propertyName : this.parentPropertyElements) {
            Element itemElement = DocumentHelper.createElement((String)"item");
            itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            itemElement.setText(propertyName);
            propertiesElement.add(itemElement);
        }
        Element refPropNameElement = refPropsItem.addElement("refPropName");
        refPropNameElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
        refPropNameElement.setText(this.refPropName);
        return true;
    }

    private boolean addPermission(Element optionsElement) {
        if (this.permission == null) {
            return false;
        }
        Element permissionElement = optionsElement.addElement("permission");
        permissionElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":string");
        permissionElement.setText(this.permission);
        return true;
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        List<Element> classElements = this.getQueryResult(bodyElement);
        this.resultList = new ArrayList<CMClass>(classElements.size());
        for (Element classElement : classElements) {
            this.resultList.add(new CMClass(classElement));
        }
    }

    private List<Element> getQueryResult(Element bodyElement) {
        this.queryResponse = bodyElement.element(BUS_QUERYRESPONSE);
        return this.queryResponse.element("queryResult").elements();
    }

    public List<CMClass> getResultList() throws CommandExecutionException {
        this.checkCommandExecuted();
        return this.resultList;
    }

    public boolean isResultEmpty() throws CommandExecutionException {
        this.checkCommandExecuted();
        return this.resultList.size() == 0;
    }

    private void checkCommandExecuted() throws CommandExecutionException {
        if (this.resultList == null) {
            throw new CommandExecutionException("The Query command has not been executed");
        }
    }

    public int getResultSetSize() throws CommandExecutionException {
        this.checkCommandExecuted();
        return this.resultList.size();
    }

    public CMClass getFirstResultClass() throws CommandExecutionException, NoSuchElementException {
        Iterator<CMClass> it = this.getResultList().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        throw new NoSuchElementException();
    }

    public void setQueryObject(String queryObjectName) {
        this.queryObjectName = queryObjectName;
    }

    public void addQueryPropertyName(String propertyName) {
        this.propertyElements.add(propertyName);
    }

    public void addQueryParentProperty(String propertyName) {
        this.parentPropertyElements.add(propertyName);
    }

    public void addRefPropName(String name) {
        this.refPropName = name;
    }

    public Element getQueryResponseElement() {
        return this.queryResponse;
    }

    public void setMimeDataEncoding() {
        this.mimeDataEncoding = MIME_DATA_ENCODING;
    }

    public void setMimeCompressedDataEncoding() {
        this.mimeDataEncoding = MIME_COMPRESSED_DATA_ENCODING;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean containsResult(String item) {
        return false;
    }
}

