/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ContentManagerUpdateCommand
extends ContentManagerCommand {
    protected static final QName BUS_UPDATE = new QName("update", BUS_NAMESPACE);
    protected static final QName BUS_OBJECTS = new QName("objects", BUS_NAMESPACE);
    private static final QName BUS_UPDATERESPONSE = new QName("updateResponse", BUS_NAMESPACE);
    private static final QName BUS_PROP_defaultName = new QName("defaultName", BUS_NAMESPACE);
    private static final QName BUS_PROP_searchPath = new QName("searchPath", BUS_NAMESPACE);
    private static final QName BUS_PROP_state = new QName("state", BUS_NAMESPACE);
    private static final QName BUS_PROP_value = new QName("value", BUS_NAMESPACE);
    private static final QName BUS_PROP_runningState = new QName("runningState", BUS_NAMESPACE);
    private static final QName BUS_PROP_dispatcherPath = new QName("dispatcherPath", BUS_NAMESPACE);
    private static final QName BUS_PROP_string = new QName("string", BUS_NAMESPACE);
    private static final QName BUS_PROP_edition = new QName("edition", BUS_NAMESPACE);
    private Collection<Element> objectElements = new ArrayList<Element>();
    private List<String> options = new ArrayList<String>();
    private Element currentObject;
    private Element updateResponse;

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        Element updateElement = bodyElement.addElement(BUS_UPDATE);
        Element objectsElement = updateElement.addElement("objects");
        objectsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        objectsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":baseClass[]");
        for (Element element : this.objectElements) {
            objectsElement.add(element);
        }
        this.objectElements.clear();
        if (this.options.size() > 0) {
            this.addOptions(updateElement);
            this.options.clear();
        }
        this.currentObject = null;
        this.addSessionRequestIds("runtimeInfo");
    }

    public void addObject(String type) {
        this.currentObject = DocumentHelper.createElement((String)"item");
        this.currentObject.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":" + type);
        this.objectElements.add(this.currentObject);
    }

    public void setDefaultName(String defName) {
        Element def = this.currentObject.addElement(BUS_PROP_defaultName);
        def.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":tokenProp");
        def.addElement(BUS_PROP_value).addText(defName);
    }

    public void setSearchPath(String searchPath) {
        if (null == searchPath) {
            return;
        }
        Element sp = this.currentObject.addElement(BUS_PROP_searchPath);
        sp.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_string.getName());
        sp.addElement(BUS_PROP_value).addText(searchPath);
    }

    public void setState(String state) {
        Element st = this.currentObject.addElement(BUS_PROP_state);
        st.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":anyTypeProp");
        st.addElement(BUS_PROP_value).addText(state);
    }

    public void setRunningState(String state) {
        Element st = this.currentObject.addElement(BUS_PROP_runningState);
        st.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":runningStateEnumProp");
        st.addElement(BUS_PROP_value).addText(state);
    }

    public void setDispatcherPath(String dispatcherPath) {
        this.addURIItem(BUS_PROP_dispatcherPath, dispatcherPath);
    }

    public void addURIItem(QName itemName, String uriStr) {
        Element def = this.currentObject.addElement(itemName);
        def.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":anyURIProp");
        def.addElement(BUS_PROP_value).addText(uriStr);
    }

    public void addStringItem(QName itemName, String value) {
        Element def = this.currentObject.addElement(itemName);
        def.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_PROP_string.getName());
        def.addElement(BUS_PROP_value).addText(value);
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
        this.updateResponse = bodyElement.element(BUS_UPDATERESPONSE);
    }

    public Element getUpdateResponse() {
        return this.updateResponse;
    }

    public void addRequestedProperty(String string) {
        this.options.add(string);
    }

    private void addOptions(Element addElement) {
        Element optionsElement = addElement.addElement("options");
        optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":updateOptions");
        Element rpElement = optionsElement.addElement("returnProperties");
        rpElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        rpElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[]");
        for (String option : this.options) {
            Element propItem = rpElement.addElement("item");
            propItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            propItem.setText(option);
        }
    }

    public void setEdition(String versionStr) {
        this.addStringItem(BUS_PROP_edition, versionStr);
    }
}

