/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountElements;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherResponse;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class AccountItems
extends ResponseItems {
    private static final String CAM_QUERY_NAME = "accountQueryCAM";
    private static final String NON_CAM_QUERY_NAME = "accountQuery";
    private static final String ACCOUNT_ITEM_NAME = "account";
    private String header;
    private AccountElements accountCAM = AccountElements.NULL;
    private AccountElements accountNonCAM = AccountElements.NULL;

    @Override
    public String getQueryName(SearchParameters searchParameters) {
        return this.accountCAM.isNull() ? CAM_QUERY_NAME : NON_CAM_QUERY_NAME;
    }

    @Override
    public boolean canHandleResponse(String responseName) {
        return AccountItems.isAccountQuery(responseName);
    }

    public static boolean isAccountQuery(String responseName) {
        return NON_CAM_QUERY_NAME.equals(responseName) || CAM_QUERY_NAME.equals(responseName);
    }

    @Override
    protected boolean isKeyItemName(String itemName) {
        return ACCOUNT_ITEM_NAME.equals(itemName);
    }

    public String getAccountName() {
        return this.getKey();
    }

    public void setAccountName(String passport) {
        this.setKey(passport);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public QueryRequest addRequestToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        if (this.hasLingeringCacheValidator()) {
            return null;
        }
        return AccountItems.isAccountQueryNeeded(searchParameters) ? super.addRequestToQuery(query, searchParameters, cacheContext) : null;
    }

    public static void addRequestForUnknownItemIfNeeded(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        if (AccountItems.isAccountQueryNeeded(searchParameters)) {
            query.addQueryRequest(CAM_QUERY_NAME);
        }
    }

    private static boolean isAccountQueryNeeded(SearchParameters searchParameters) {
        return !searchParameters.isSearchingForDatasourceSignon();
    }

    @Override
    protected void parseAndSaveItem(String itemName, XMLStreamReader reader) throws XMLStreamException {
        if (this.isAccount(itemName)) {
            this.parseAndSaveAccountItem(itemName, reader);
        } else {
            super.parseAndSaveItem(itemName, reader);
        }
    }

    private boolean isAccount(String itemName) {
        return ACCOUNT_ITEM_NAME.equals(itemName);
    }

    private void parseAndSaveAccountItem(String itemName, XMLStreamReader reader) throws XMLStreamException {
        AccountElements accountElements = this.parseAccountItem(reader);
        if (this.isFirstAccountItem()) {
            this.accountNonCAM = accountElements;
        } else {
            this.accountCAM = accountElements;
        }
    }

    private AccountElements parseAccountItem(XMLStreamReader reader) throws XMLStreamException {
        if (this.hasNoAccountName()) {
            throw new RuntimeException("Can't parse account item without knowing its search path");
        }
        List<String> accountElements = this.getAccountElements(reader);
        return new AccountElements(accountElements);
    }

    private boolean hasNoAccountName() {
        return this.getAccountName() == null;
    }

    private List<String> getAccountElements(XMLStreamReader reader) throws XMLStreamException {
        return this.getChildrenElements("item", reader);
    }

    private boolean isFirstAccountItem() {
        return this.accountNonCAM.isNull();
    }

    @Override
    public QueryResult getQueryResultFor(String itemName, SearchParameters searchParameters) {
        return this.isAccount(itemName) ? this.getAccountQueryResult() : super.getQueryResultFor(itemName, searchParameters);
    }

    private QueryResult getAccountQueryResult() {
        ArrayList<String> accountItems = new ArrayList<String>();
        accountItems.add(SoapTokens.getStartAccountItem());
        accountItems.addAll(this.accountNonCAM.getElements());
        accountItems.addAll(this.accountCAM.getElements());
        accountItems.add(SoapTokens.getEndAccountItem());
        return new QueryResult(accountItems, 1);
    }

    @Override
    protected String getItem(String itemName) {
        return this.isAccount(itemName) ? this.getAccountItemAsString() : super.getItem(itemName);
    }

    private String getAccountItemAsString() {
        return AccountItems.listToString(this.getAccountQueryResult().getStrings());
    }

    private static String listToString(List<String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            result.append(string).append("\r\n");
        }
        return result.toString();
    }

    @Override
    public QueryResult getAllItems() {
        QueryResult accountItems = new QueryResult();
        for (String itemName : this.getAllItemNames()) {
            accountItems.add(this.getItem(itemName));
        }
        return accountItems;
    }

    @Override
    protected void addFullRepliesElement(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        List<String> sessionItems = this.getSessionItems();
        response.addResponseLine(SoapTokens.getStartReplies(this.getTotalNumberOfItems(sessionItems)));
        this.addItems(response, sessionItems);
        this.addAccountElementIfNeeded(response, this.accountNonCAM);
        this.addAccountElementIfNeeded(response, this.accountCAM);
        response.addResponseLine(SoapTokens.getEndReplies());
    }

    private List<String> getSessionItems() {
        ArrayList<String> allAccountItems = new ArrayList<String>();
        allAccountItems.addAll(this.getAllItemValues());
        return allAccountItems;
    }

    private int getTotalNumberOfItems(List<String> sessionItems) {
        int numberOfItems = sessionItems.size();
        if (!this.accountCAM.isNull()) {
            ++numberOfItems;
        }
        if (!this.accountNonCAM.isNull()) {
            ++numberOfItems;
        }
        return numberOfItems;
    }

    private void addAccountElementIfNeeded(RemoteDispatcherResponse response, AccountElements accountElement) {
        if (!accountElement.isNull()) {
            this.addAccountElement(response, accountElement);
        }
    }

    private void addAccountElement(RemoteDispatcherResponse response, AccountElements accountElement) {
        response.addResponseLine(SoapTokens.getStartItemElement());
        response.addResponseLine(SoapTokens.getStartAccountItem());
        response.addResponseLines(accountElement.getElements());
        response.addResponseLine(SoapTokens.getEndAccountItem());
        response.addResponseLine(SoapTokens.getEndItemElement());
    }

    @Override
    public AccountItems intern() {
        this.accountCAM.intern();
        this.accountNonCAM.intern();
        return this;
    }

    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        this.accountCAM.handleRemovalFromCache();
        this.accountNonCAM.handleRemovalFromCache();
    }

    public void importCamElementsFromTheCache(AccountItems accountItemsFromTheCache) {
        if (accountItemsFromTheCache.hasCamElements()) {
            this.accountCAM = accountItemsFromTheCache.accountCAM;
        }
    }

    private boolean hasCamElements() {
        return !this.accountCAM.getElements().isEmpty();
    }

    private boolean hasNonCamElements() {
        return !this.accountNonCAM.getElements().isEmpty();
    }

    public boolean hasAccountData() {
        return this.hasCamElements() || this.hasNonCamElements();
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        log.debug(indent, "header: ", this.getStringForLogging(this.header));
        log.debug(indent, "accountCAM: ", this.accountCAM);
        log.debug(indent, "accountNonCAM: ", this.accountNonCAM);
    }

    @Override
    public String getKeyForCacheContext() {
        return AccountItems.getChecksumFor(this.getKey());
    }

    public static String getChecksumFor(String s) {
        return String.valueOf(StringUtils.getChecksum(s));
    }
}

