/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CMCacheServiceListener;
import com.cognos.pogo.contentmanager.cache.CacheServiceConfiguration;
import com.cognos.pogo.transport.FormRequestProcessor;
import java.util.HashSet;
import java.util.Set;

public class CMCacheService {
    public static final String NAME = "contentManagerCacheService";
    public static final String SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/contentManagerCacheService" + FormRequestProcessor.C10_SERVICE_VERSION_SUFFIX;
    private static CacheServiceConfiguration config;
    private static boolean isSuspended;
    private static Set<CMCacheServiceListener> listeners;

    public static synchronized CacheServiceConfiguration getConfig() {
        return config;
    }

    public static synchronized void setConfig(CacheServiceConfiguration config) {
        boolean previousState = CMCacheService.isEnabled();
        CMCacheService.config = config;
        CMCacheService.notifyListenersIfNeeded(previousState);
    }

    private static void notifyListenersIfNeeded(boolean previousState) {
        boolean currentState = CMCacheService.isEnabled();
        if (currentState != previousState) {
            CMCacheService.notifyListeners();
        }
    }

    private static void notifyListeners() {
        for (CMCacheServiceListener listener : listeners) {
            listener.notifyCmCacheStateChange(CMCacheService.isEnabled());
        }
    }

    public static boolean isEnabled() {
        if (isSuspended) {
            return false;
        }
        CacheServiceConfiguration config = CMCacheService.getConfig();
        return config != null && config.isEnabled();
    }

    static void setSuspended(boolean suspended) {
        boolean previousState = CMCacheService.isEnabled();
        isSuspended = suspended;
        CMCacheService.notifyListenersIfNeeded(previousState);
    }

    public static void registerForNotifications(CMCacheServiceListener listener) {
        listeners.add(listener);
    }

    static {
        listeners = new HashSet<CMCacheServiceListener>();
    }
}

