/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.contentmanager.cache.CacheElementMap;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.Hint;
import com.cognos.pogo.contentmanager.cache.Hints;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log.Priority;

public abstract class CacheContainer
extends CacheElement
implements Comparable<CacheContainer>,
Hints,
Hint {
    private static PogoLogger log = PogoLogger.getLogger();
    private ResponseItems responseItems;
    private final CacheElementMap<String, CacheContainer> internalContainers;
    private final int hierarchyLevel;

    public CacheContainer(CacheContainer parent, ResponseItems responseItems) {
        this(parent, responseItems, CacheContainer.getChildHierarchyLevel(parent));
    }

    public CacheContainer(CacheContainer parent, ResponseItems responseItems, int hierarchyLevel) {
        super(parent);
        this.hierarchyLevel = hierarchyLevel;
        this.setResponseItems(responseItems);
        this.internalContainers = new CacheElementMap(this);
    }

    private static int getChildHierarchyLevel(CacheContainer parent) {
        return parent != null ? parent.getHierarchyLevel() + 1 : 0;
    }

    protected int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    protected void setResponseItems(ResponseItems newResponseItems) {
        this.updateAccessTime();
        this.removeOldResponseItems();
        this.addNewResponseItems(newResponseItems);
    }

    private void removeOldResponseItems() {
        if (this.responseItems != null) {
            this.responseItems.handleRemovalFromCache();
        }
    }

    private void addNewResponseItems(ResponseItems newResponseItems) {
        if (newResponseItems != null) {
            newResponseItems.intern();
            newResponseItems.setOwner(this);
        }
        this.responseItems = newResponseItems;
    }

    protected ResponseItems getResponseItems() {
        this.updateAccessTime();
        return this.responseItems;
    }

    @Override
    public String getName() {
        return this.responseItems != null ? this.responseItems.getKey() : null;
    }

    @Override
    public String getValidator() {
        return this.responseItems != null ? this.responseItems.getCacheValidator() : null;
    }

    @Override
    public Collection<Hint> getHints() {
        return this.getInternalContainers();
    }

    protected void renewCacheValidators(ResponseItems responseItemsFromCM) {
        this.renewResponseItemsCacheValidator(responseItemsFromCM);
    }

    private void renewResponseItemsCacheValidator(ResponseItems responseItemsFromCM) {
        if (this.needsToRenewCacheValidator(responseItemsFromCM)) {
            this.responseItems.renewCacheValidator(responseItemsFromCM);
        }
    }

    private boolean needsToRenewCacheValidator(ResponseItems responseItemsFromCM) {
        return this.responseItems != null && responseItemsFromCM != null && responseItemsFromCM.hasCacheValidator();
    }

    protected void renewCacheValidators(String internalContainerName, CachedResponse responseFromCM) {
        this.renewInternalContainerCacheValidator(internalContainerName, responseFromCM);
    }

    private void renewInternalContainerCacheValidator(String internalContainerName, CachedResponse responseFromCM) {
        CacheContainer internalContainer = this.getContainer(internalContainerName);
        if (internalContainer != null) {
            internalContainer.renewCacheValidators(responseFromCM);
        }
    }

    protected abstract void renewCacheValidators(CachedResponse var1);

    public void leaveCache() {
        log.debug("DELETING ", this);
        this.removeAllChildContainers();
        this.leaveParent();
    }

    private void removeAllChildContainers() {
        for (CacheContainer container : this.getInternalContainersSnapshot()) {
            this.removeChildContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CacheContainer> getInternalContainersSnapshot() {
        Object object = this.internalContainers.getMutex();
        synchronized (object) {
            return new ArrayList<CacheContainer>(this.internalContainers.values());
        }
    }

    private void leaveParent() {
        CacheContainer parent = this.getParent();
        if (parent != null) {
            parent.removeChildContainer(this);
        }
    }

    @Override
    public CacheContainer getParent() {
        return (CacheContainer)super.getParent();
    }

    protected void saveChildContainer(String name, CacheContainer container) {
        log.debug(this, ".saveContainer(", name, ", ", container, ")");
        CacheContainer previousContainer = this.saveContainerAndReturnThePreviousOne(name, container);
        if (previousContainer != null) {
            this.handleElementRemovedFromCache(previousContainer);
        }
    }

    private CacheContainer saveContainerAndReturnThePreviousOne(String name, CacheContainer container) {
        return name != null ? this.internalContainers.put(this.intern(name), container) : null;
    }

    protected void removeChildContainer(CacheContainer cacheContainer) {
        String childContainerName = cacheContainer.getName();
        log.debug(this, ".removeContainer(", childContainerName, ")");
        CacheContainer childContainerRemoved = this.internalContainers.remove(childContainerName);
        if (childContainerRemoved != null) {
            this.handleElementRemovedFromCache(childContainerName, childContainerRemoved);
        }
    }

    public boolean isParentOf(CacheContainer cacheContainer) {
        return cacheContainer != null && this.internalContainers.containsKey(cacheContainer);
    }

    public boolean isChildContainer() {
        return this.getHierarchyLevel() > 0;
    }

    public boolean isEmpty() {
        return this.internalContainers.isEmpty();
    }

    protected CacheContainer getContainer(String name) {
        return name != null ? this.internalContainers.get(name) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheContainersToList(List<CacheContainer> list) {
        list.add(this);
        Object object = this.internalContainers.getMutex();
        synchronized (object) {
            for (CacheContainer container : this.internalContainers.values()) {
                container.addCacheContainersToList(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalNumberOfContainers() {
        int total = 1;
        Object object = this.internalContainers.getMutex();
        synchronized (object) {
            for (CacheContainer container : this.internalContainers.values()) {
                total = (int)((long)total + container.getTotalNumberOfContainers());
            }
        }
        return total;
    }

    protected int getNumberOfInternalContainers() {
        return this.internalContainers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfSubContainers() {
        int total = 0;
        Object object = this.internalContainers.getMutex();
        synchronized (object) {
            for (CacheContainer container : this.internalContainers.values()) {
                total += container.getNumberOfInternalContainers();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfSubSubContainers() {
        int total = 0;
        Object object = this.internalContainers.getMutex();
        synchronized (object) {
            for (CacheContainer container : this.internalContainers.values()) {
                total += container.getNumberOfSubContainers();
            }
        }
        return total;
    }

    protected Collection<?> getInternalContainers() {
        return Collections.unmodifiableCollection(this.internalContainers.values());
    }

    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        if (this.getResponseItems() != null) {
            this.getResponseItems().handleRemovalFromCache();
        }
    }

    @Override
    public int compareTo(CacheContainer other) {
        int ageDifference = this.getAgeDifference(other);
        return ageDifference != 0 ? ageDifference : this.getTypeDifference(other);
    }

    private int getTypeDifference(CacheContainer other) {
        return other.getHierarchyLevel() - this.getHierarchyLevel();
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        this.dump(log, indent, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PogoLogger log, String indent, String internalContainerName) {
        super.dump(log, indent);
        indent = indent + "   ";
        if (this.getResponseItems() != null) {
            this.getResponseItems().dump(log, indent);
        }
        log.debug(indent, internalContainerName);
        indent = indent + "   ";
        Object object = this.internalContainers.getMutex();
        synchronized (object) {
            for (Map.Entry<String, CacheContainer> entry : this.internalContainers.entrySet()) {
                log.debug(indent, "key: ", entry.getKey());
                entry.getValue().dump(log, indent);
            }
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    @Override
    public String toString() {
        return this.toString("key");
    }

    public String toString(String keyName) {
        return this.getClassName() + "(" + keyName + ": " + this.getName() + ")";
    }
}

