/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.LocalDispatcherSession;
import com.cognos.pogo.contentmanager.cache.SearchType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ClientRequestValidator {
    private final LocalDispatcherSession clientRequestSession;
    private final String faultString;
    private static final String NO_FAULT = null;
    private static final Map<SearchType, Set<String>> validItemsBySearchType = new HashMap<SearchType, Set<String>>();

    protected static void defineValidAccountItems() {
        HashSet<String> validItems = new HashSet<String>();
        validItems.add("account");
        validItems.add("session");
        validItemsBySearchType.put(SearchType.ACCOUNT, validItems);
    }

    protected static void defineValidPackageItems() {
        HashSet<String> validItems = new HashSet<String>();
        validItems.add("account");
        validItems.add("session");
        validItems.add("package");
        validItems.add("packageConfiguration");
        validItemsBySearchType.put(SearchType.PACKAGE, validItems);
    }

    protected static void defineValidModelItems() {
        HashSet<String> validItems = new HashSet<String>();
        validItems.add("account");
        validItems.add("session");
        validItems.add("package");
        validItems.add("packageConfiguration");
        validItems.add("model");
        validItems.add("modelView");
        validItemsBySearchType.put(SearchType.MODEL, validItems);
    }

    protected static void defineValidReportItems() {
        HashSet<String> validItems = new HashSet<String>();
        validItems.add("account");
        validItems.add("session");
        validItems.add("package");
        validItems.add("packageConfiguration");
        validItems.add("model");
        validItems.add("modelView");
        validItems.add("report");
        validItems.add("reportCache");
        validItems.add("reportMetadata");
        validItems.add("dataSourceSignon");
        validItemsBySearchType.put(SearchType.REPORT, validItems);
    }

    protected static void defineValidDatasourceSignonItems() {
        HashSet<String> validItems = new HashSet<String>();
        validItems.add("dataSourceSignon");
        validItemsBySearchType.put(SearchType.DATASOURCESIGNON, validItems);
    }

    protected static Map<SearchType, Set<String>> getValidItemsBySearchTypeMap() {
        return validItemsBySearchType;
    }

    public ClientRequestValidator(LocalDispatcherSession clientRequestSession) {
        this.clientRequestSession = clientRequestSession;
        this.faultString = this.createFaultString();
    }

    private String createFaultString() {
        String faultMessage = this.getFaultStringForInvalidObjectPath();
        if (faultMessage == NO_FAULT) {
            faultMessage = this.getFaultStringForInvalidEntries();
        }
        if (faultMessage == NO_FAULT) {
            faultMessage = this.getFaultStringForMissingSearchType();
        }
        if (faultMessage == NO_FAULT) {
            faultMessage = this.getFaultStringForInvalidItem();
        }
        if (faultMessage == NO_FAULT) {
            faultMessage = this.getFaultStringForMissingCamHeader();
        }
        return faultMessage;
    }

    private String getFaultStringForInvalidObjectPath() {
        String objectPath = this.clientRequestSession.getSearchParameters().getObjectPath();
        return StringUtils.isEmpty((String)objectPath) ? "Missing object path" : NO_FAULT;
    }

    private String getFaultStringForInvalidEntries() {
        List<String> items = this.clientRequestSession.getQueryCacheElement().getItems();
        return items.isEmpty() ? "Missing entries" : NO_FAULT;
    }

    private String getFaultStringForMissingSearchType() {
        SearchType searchType = this.clientRequestSession.getSearchParameters().getSearchType();
        return searchType == SearchType.NULL ? "Missing search type" : NO_FAULT;
    }

    private String getFaultStringForInvalidItem() {
        SearchType searchType = this.clientRequestSession.getSearchParameters().getSearchType();
        Set<String> validItems = validItemsBySearchType.get((Object)searchType);
        for (String item : this.clientRequestSession.getQueryCacheElement().getItems()) {
            if (!this.isInvalidItem(item, validItems)) continue;
            return this.buildFaultStringFor(searchType, item);
        }
        return NO_FAULT;
    }

    private boolean isInvalidItem(String item, Set<String> validItemsForSearchType) {
        return validItemsForSearchType == null || !validItemsForSearchType.contains(item);
    }

    private String buildFaultStringFor(SearchType searchType, String itemName) {
        return "Invalid query item [" + itemName + "] for search type [" + (Object)((Object)searchType) + "]";
    }

    private String getFaultStringForMissingCamHeader() {
        return this.hasNoCamHeader() ? "Missing CAM element in the BiBus header" : NO_FAULT;
    }

    private boolean hasNoCamHeader() {
        return this.clientRequestSession.getRequestEnvelope().getBiBusHeader().getCam().isEmpty();
    }

    public boolean isRequestInvalid() {
        return this.faultString != NO_FAULT;
    }

    public String getFaultString() {
        return this.faultString;
    }

    static {
        ClientRequestValidator.defineValidAccountItems();
        ClientRequestValidator.defineValidPackageItems();
        ClientRequestValidator.defineValidModelItems();
        ClientRequestValidator.defineValidReportItems();
        ClientRequestValidator.defineValidDatasourceSignonItems();
    }
}

