/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class CustomStreamReaderDelegate
extends StreamReaderDelegate {
    private final String outerElementName;
    private final String innerElementName;
    private boolean foundOuterElement = false;
    private boolean foundInnerElement = false;
    private boolean stopSearching = false;
    private StringBuilder innerElementText = new StringBuilder();

    public CustomStreamReaderDelegate(XMLStreamReader reader, String outerElementName, String innerElementName) {
        super(reader);
        this.outerElementName = outerElementName;
        this.innerElementName = innerElementName;
    }

    @Override
    public int next() throws XMLStreamException {
        int event = super.next();
        if (!this.stopSearching) {
            switch (event) {
                case 1: {
                    String localName = this.getLocalName();
                    if (!this.foundOuterElement && localName.equals(this.outerElementName)) {
                        this.foundOuterElement = true;
                        break;
                    }
                    if (!this.foundOuterElement || !localName.equals(this.innerElementName)) break;
                    this.foundInnerElement = true;
                    break;
                }
                case 4: {
                    if (!this.foundInnerElement) break;
                    this.innerElementText.append(this.getText());
                    break;
                }
                case 2: {
                    if (!this.foundInnerElement) break;
                    this.stopSearching = true;
                }
            }
        }
        return event;
    }

    public String getInnerElementText() {
        return this.innerElementText.toString();
    }
}

