/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.contentmanager.cache.Items;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.List;

public class KeyItems
extends CacheElement {
    private String key;
    private Items items;

    public KeyItems() {
        this((String)null);
    }

    public KeyItems(String name) {
        this.setKey(name);
        this.items = new Items();
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyForCacheContext() {
        return this.key;
    }

    protected void saveItem(String itemName, String itemBody) {
        this.items.put(itemName, itemBody);
    }

    protected String getItem(String itemName) {
        return this.items.get(itemName);
    }

    public QueryResult getAllItems() {
        return new QueryResult(this.getAllItemValues());
    }

    public List<String> getAllItemValues() {
        return this.items.getValues();
    }

    public QueryResult getAllItemsFor(String itemName) {
        return new QueryResult(this.getValuesFor(itemName));
    }

    public List<String> getValuesFor(String itemName) {
        return this.items.getValuesFor(itemName);
    }

    public List<String> getAllItemNames() {
        return this.items.getNames();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    protected void clear() {
        this.items.clear();
    }

    public void importItemsFromTheCache(KeyItems itemsFromTheCache) {
        ArrayList<String> itemNames = new ArrayList<String>();
        ArrayList<String> itemValues = new ArrayList<String>();
        itemsFromTheCache.writeNamesAndValuesTo(itemNames, itemValues);
        this.addItems(itemNames, itemValues);
    }

    private void writeNamesAndValuesTo(List<String> itemNames, List<String> itemValues) {
        this.items.writeNamesAndValuesTo(itemNames, itemValues);
    }

    private void addItems(List<String> itemNames, List<String> itemValues) {
        for (int i = 0; i < itemNames.size(); ++i) {
            this.saveItem(itemNames.get(i), itemValues.get(i));
        }
    }

    public KeyItems intern() {
        this.setKey(this.intern(this.getKey()));
        this.items.intern();
        return this;
    }

    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        this.items.handleRemovalFromCache();
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        log.debug(indent, "key: ", this.getKey());
        this.items.dump(log, indent);
    }

    @Override
    public String toString() {
        return this.getClassName() + '(' + this.getKey() + ')';
    }
}

