/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.ClientRequestValidator;
import com.cognos.pogo.contentmanager.cache.DispatcherSession;
import com.cognos.pogo.contentmanager.cache.FaultResponse;
import com.cognos.pogo.contentmanager.cache.HandlerConfig;
import com.cognos.pogo.contentmanager.cache.QueryCacheElement;
import com.cognos.pogo.contentmanager.cache.QueryResponse;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.contentmanager.cache.level2.Level2Client;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PerfTimer;
import com.cognos.pogo.util.PogoLogger;
import org.apache.log.Priority;

public class LocalDispatcherSession
extends DispatcherSession {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final Level2Client cmClient;
    private CachedResponse responseFromCache;
    private CachedResponse responseFromCM;
    private QueryCacheElement queryCacheElement;
    private ClientRequestValidator requestValidator;

    public LocalDispatcherSession(MessageContext messageContext, ResponseCache responseCache, HandlerConfig hc) {
        super(messageContext, responseCache, hc);
        this.cmClient = new Level2Client(hc, this.getPerfLogger());
    }

    @Override
    protected PogoLogger getLog() {
        return log;
    }

    @Override
    protected String getRequestName() {
        return "contentManagerCacheService";
    }

    @Override
    protected void processRequest() {
        if (this.isClientRequestInvalid()) {
            this.createInvalidRequestFault();
        } else {
            this.processValidRequest();
        }
    }

    @Override
    protected void createSearchParameters() {
        this.queryCacheElement = QueryCacheElement.createInstance(this.getRequestEnvelope(), this.getPassport());
        this.setSearchParameters(this.queryCacheElement.createSearchParameters());
    }

    @Override
    protected void logRequest() {
        log.debug("Handling ", "contentManagerCacheService", " request from client: ", this.getRequestEnvelope());
        this.getSearchParameters().dump(log, "");
        this.queryCacheElement.dump(log, "");
    }

    private boolean isClientRequestInvalid() {
        this.requestValidator = new ClientRequestValidator(this);
        return this.requestValidator.isRequestInvalid();
    }

    private void createInvalidRequestFault() {
        this.sendSoapFault(this.requestValidator.getFaultString(), null);
    }

    private void processValidRequest() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL3, "processValidRequest", this.getSearchParameters().getObjectPath());
        if (this.needsToQueryCM()) {
            this.queryCM();
        }
        this.createResponseToClient();
        this.stopPerfTimer(timer);
    }

    private boolean needsToQueryCM() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL4, "needsToQueryCM", new Object[0]);
        this.responseFromCache = this.getResponseCache().getCachedResponse(this.getPassport(), this.getSearchParameters());
        boolean queryCM = this.responseFromCache == null || this.queryCacheElement.needsToQueryCM(this.responseFromCache, this.getSearchParameters()) ? true : this.responseFromCache.hasAnExpiredCacheValidator();
        this.stopPerfTimer(timer);
        return queryCM;
    }

    private void queryCM() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL4, "queryCM", new Object[0]);
        this.sendQuery();
        if (this.responseFromCM.hasNoFault()) {
            this.saveResponse();
        }
        this.stopPerfTimer(timer);
    }

    private void sendQuery() {
        this.responseFromCM = this.cmClient.sendQuery(this, this.responseFromCache);
        if (this.responseFromCM.hasHeaderFault()) {
            this.responseFromCM = this.cmClient.resendQueryUsingFullHeader(this, this.responseFromCache);
        } else if (this.responseFromCM.hasNoReadFault()) {
            this.responseFromCM = this.cmClient.resendQueryUsingFullTrustedHeader(this, this.responseFromCache);
        }
    }

    private void saveResponse() {
        this.updateHeader();
        if (this.failedCacheValidation()) {
            this.updateCache();
        }
        this.renewCacheValidators();
    }

    private void updateHeader() {
        this.getResponseCache().updateHeader(this.getPassport(), this.responseFromCM);
    }

    private boolean failedCacheValidation() {
        return this.responseFromCM.hasCacheValidatorsNewerThan(this.responseFromCache);
    }

    private void updateCache() {
        this.addMissingLingeringItemsIntoResponseFromCM();
        this.getResponseCache().put(this.getPassport(), this.responseFromCM);
        this.responseFromCache = this.responseFromCM;
    }

    private void addMissingLingeringItemsIntoResponseFromCM() {
        if (!this.needToAddLingeringItems()) {
            return;
        }
        if (this.isAccountLingering()) {
            this.responseFromCM.setAccountItems(this.responseFromCache.getAccountItems());
        }
        if (this.isPackageLingering()) {
            this.responseFromCM.setPackageItems(this.responseFromCache.getPackageItems());
        }
        if (this.isReportLingering()) {
            this.responseFromCM.setReportItems(this.responseFromCache.getReportItems());
        }
    }

    private boolean needToAddLingeringItems() {
        return this.responseFromCache != null && !this.getSearchParameters().isSearchingForDatasourceSignon();
    }

    private boolean isReportLingering() {
        return this.responseFromCM.getReportItems().getCacheValidator() == null;
    }

    private boolean isPackageLingering() {
        return this.responseFromCM.getPackageItems().getCacheValidator() == null;
    }

    private boolean isAccountLingering() {
        return this.responseFromCM.getAccountItems().getCacheValidator() == null;
    }

    private void renewCacheValidators() {
        this.getResponseCache().renewCacheValidators(this.responseFromCM);
    }

    private void createResponseToClient() {
        PerfTimer timer = this.startPerfTimer(PerfLogger.Level.LEVEL4, "createResponseToClient", new Object[0]);
        if (this.hasFaultFromCM()) {
            this.createCMFaultResponse();
        } else {
            this.createSuccessfulResponse();
        }
        this.stopPerfTimer(timer);
    }

    private boolean hasFaultFromCM() {
        return this.responseFromCM != null && this.responseFromCM.hasFault();
    }

    private void createCMFaultResponse() {
        FaultResponse response = new FaultResponse(this.responseFromCM);
        this.setResponseEnvelope(response.getEnvelope());
    }

    private void createSuccessfulResponse() {
        QueryResponse response = new QueryResponse(this.queryCacheElement, this.responseFromCache, this.getSearchParameters());
        this.setResponseEnvelope(response.getEnvelope());
    }

    public QueryCacheElement getQueryCacheElement() {
        return this.queryCacheElement;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

