/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.AccountItems;
import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.DatasourceSignon;
import com.cognos.pogo.contentmanager.cache.DatasourceSignons;
import com.cognos.pogo.contentmanager.cache.ItemStreamReaderDelegate;
import com.cognos.pogo.contentmanager.cache.KeyItems;
import com.cognos.pogo.contentmanager.cache.Model;
import com.cognos.pogo.contentmanager.cache.Models;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SearchPathUtils;
import com.cognos.pogo.contentmanager.cache.SearchType;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.contentmanager.cache.context.CacheContext;
import com.cognos.pogo.contentmanager.cache.level2.Level2Query;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherResponse;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PackageItems
extends ResponseItems {
    private static final String MAIN_ITEM_NAME = "package";
    private static final String PACKAGE_QUERY_NAME = "packageQuery";
    private Models models = new Models();
    private DatasourceSignons datasourceSignons = new DatasourceSignons();

    @Override
    public String getQueryName(SearchParameters searchParameters) {
        return searchParameters.isSearchingForDatasourceSignon() ? DatasourceSignon.getQueryName() : PACKAGE_QUERY_NAME;
    }

    @Override
    public boolean canHandleResponse(String responseName) {
        return PACKAGE_QUERY_NAME.equals(responseName) || DatasourceSignon.isDatasourceSignonQuery(responseName);
    }

    @Override
    protected boolean isKeyItemName(String itemName) {
        return MAIN_ITEM_NAME.equals(itemName);
    }

    public static String getPackageQueryName() {
        return PACKAGE_QUERY_NAME;
    }

    public String getPackageName() {
        return this.getKey();
    }

    public void setPackageName(String searchPath) {
        this.setKey(searchPath);
    }

    public static void addRequestForUnknownItem(Level2Query query, SearchParameters sp, CachedResponse cachedResponse, CacheContext cacheContext) {
        if (sp.isSearchingForReport()) {
            PackageItems.addRequestForUnknownReportQuery(query, cachedResponse, cacheContext);
        } else if (sp.isSearchingForPackage()) {
            PackageItems.addRequestForUnknownPackageQuery(query, sp.getObjectPath(), cacheContext);
        } else if (sp.isSearchingForDatasourceSignon()) {
            PackageItems.addRequestForUnknownDatasource(query, sp);
        } else if (sp.isSearchingForModel()) {
            PackageItems.addRequestForUnknownPackageQuery(query, SearchPathUtils.getPackageFromModel(sp.getObjectPath()), cacheContext);
        }
    }

    private static void addRequestForUnknownDatasource(Level2Query query, SearchParameters sp) {
        String datasourceSearchPath = sp.getObjectPath();
        String datasourceSignonName = SearchPathUtils.getDatasourceSignonSearchPath(datasourceSearchPath);
        DatasourceSignon.addRequestForUnknownItem(query, datasourceSignonName);
    }

    private static void addRequestForUnknownReportQuery(Level2Query query, CachedResponse cachedResponse, CacheContext cacheContext) {
        QueryRequest request = query.addQueryRequest(PACKAGE_QUERY_NAME);
        request.setSource(query.getQueryReportId());
        if (cachedResponse != null) {
            request.setHints(cachedResponse.getAccountItems().getOwner());
        }
    }

    private static void addRequestForUnknownPackageQuery(Level2Query query, String packageSearchPath, CacheContext cacheContext) {
        QueryRequest request = query.addQueryRequest(PACKAGE_QUERY_NAME);
        request.setSearchPath(packageSearchPath);
    }

    @Override
    public QueryRequest addRequestToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        if (searchParameters.isSearchingForDatasourceSignon()) {
            return this.datasourceSignons.addRequestToQuery(query, searchParameters, cacheContext);
        }
        return this.addPackageRequestToQuery(query, searchParameters, cacheContext);
    }

    private QueryRequest addPackageRequestToQuery(Level2Query query, SearchParameters searchParameters, CacheContext cacheContext) {
        if (this.canSkipPackageQuery(searchParameters)) {
            return null;
        }
        QueryRequest request = super.addRequestToQuery(query, searchParameters, cacheContext);
        request.setSearchPath(this.getPackageName());
        this.datasourceSignons.addAllDatasourceSignonsToQuery(query, searchParameters, cacheContext);
        return request;
    }

    private boolean canSkipPackageQuery(SearchParameters searchParameters) {
        return !this.isEmpty() && this.hasLingeringCacheValidator() && this.modelCheck(searchParameters);
    }

    private boolean modelCheck(SearchParameters searchParameters) {
        return !searchParameters.isSearchingForModel() || this.getModel(searchParameters.getObjectPath()) != null;
    }

    @Override
    protected void parseAndSaveItem(String itemName, XMLStreamReader reader) throws XMLStreamException {
        if (this.isModel(itemName)) {
            this.parseModelItem(reader);
        } else if (this.isModelView(itemName)) {
            this.parseModelViewItem(reader);
        } else {
            super.parseAndSaveItem(itemName, reader);
        }
    }

    private boolean isModel(String itemName) {
        return "model".equals(itemName);
    }

    private void parseModelItem(XMLStreamReader reader) throws XMLStreamException {
        ItemStreamReaderDelegate itemReader = new ItemStreamReaderDelegate(reader);
        String itemBody = this.getCurrentElement(itemReader);
        String modelSearchPath = itemReader.getSearchPath();
        this.models.saveModel(modelSearchPath, itemBody);
    }

    private boolean isModelView(String itemName) {
        return "modelView".equals(itemName);
    }

    private void parseModelViewItem(XMLStreamReader reader) throws XMLStreamException {
        ItemStreamReaderDelegate itemReader = new ItemStreamReaderDelegate(reader);
        String itemBody = this.getCurrentElement(itemReader);
        String modelViewSearchPath = itemReader.getSearchPath();
        this.models.saveModelView(modelViewSearchPath, itemBody);
    }

    private boolean isDatasourceSignon(String name) {
        return DatasourceSignon.isDatasourceSignonItem(name) || DatasourceSignon.isDatasourceSignonQuery(name);
    }

    @Override
    public void parseResponse(String responseName, Map<String, String> attributes, XMLStreamReader reader) throws XMLStreamException {
        if (this.isDatasourceSignon(responseName)) {
            this.datasourceSignons.parseResponse(responseName, attributes, reader);
        } else {
            super.parseResponse(responseName, attributes, reader);
        }
    }

    @Override
    public boolean hasCacheValidatorNewerThan(ResponseItems responseItemsFromCache) {
        PackageItems packageItemsFromCache = (PackageItems)responseItemsFromCache;
        return super.hasCacheValidatorNewerThan(packageItemsFromCache) || this.datasourceSignons.hasDatasourceSignonWithFailedValidation();
    }

    @Override
    public boolean hasAnExpiredCacheValidator() {
        return super.hasAnExpiredCacheValidator() || this.datasourceSignons.hasAnExpiredCacheValidator();
    }

    @Override
    public void renewCacheValidator(ResponseItems responseItemsFromCM) {
        super.renewCacheValidator(responseItemsFromCM);
        this.renewDatasourceCacheValidators(responseItemsFromCM);
    }

    private void renewDatasourceCacheValidators(ResponseItems responseItemsFromCM) {
        DatasourceSignons datasourcesFromCM;
        DatasourceSignons datasourceSignons = datasourcesFromCM = responseItemsFromCM != null ? responseItemsFromCM.getDatasourceSignons() : null;
        if (datasourcesFromCM != null) {
            this.datasourceSignons.renewCacheValidators(datasourcesFromCM);
        }
    }

    @Override
    protected DatasourceSignons getDatasourceSignons() {
        return this.datasourceSignons;
    }

    @Override
    public QueryResult getQueryResultFor(String itemName, SearchParameters searchParameters) {
        if (this.isModel(itemName)) {
            return this.getModelItem(searchParameters);
        }
        if (this.isModelView(itemName)) {
            return this.getModelViewItems(searchParameters);
        }
        if (this.isDatasourceSignon(itemName)) {
            return this.getDatasourceSignonItems(searchParameters);
        }
        return super.getQueryResultFor(itemName, searchParameters);
    }

    private QueryResult getModelItem(SearchParameters searchParameters) {
        Model model = this.getModelFor(searchParameters);
        return model != null ? model.getModelItem() : QueryResult.NULL;
    }

    private Model getModelFor(SearchParameters searchParameters) {
        boolean isSearchingForModel = searchParameters != null && searchParameters.isSearchingForModel();
        String modelSearchPath = isSearchingForModel ? searchParameters.getObjectPath() : null;
        return modelSearchPath != null ? this.models.getModel(modelSearchPath) : null;
    }

    public Model getModel(String modelSearchPath) {
        return this.models.getModel(modelSearchPath);
    }

    public Models getModels() {
        return this.models;
    }

    private QueryResult getModelViewItems(SearchParameters searchParameters) {
        Model model = this.getModelFor(searchParameters);
        return model != null ? model.getAllModelViews() : QueryResult.NULL;
    }

    protected QueryResult getDatasourceSignonItems(SearchParameters searchParameters) {
        if (SearchType.DATASOURCESIGNON == searchParameters.getSearchType()) {
            String datasourceSignonSearchPath = searchParameters.getObjectPath();
            DatasourceSignon datasource = this.datasourceSignons.getDatasourceSignon(datasourceSignonSearchPath);
            return datasource != null ? datasource.getAllItems() : QueryResult.NULL;
        }
        ArrayList<String> lItems = new ArrayList<String>();
        for (KeyItems keyItems : this.datasourceSignons.getDatasourceSignonList()) {
            lItems.addAll(keyItems.getAllItemValues());
        }
        return lItems.size() > 0 ? new QueryResult(lItems) : QueryResult.NULL;
    }

    @Override
    public AccountItems getParent() {
        return (AccountItems)super.getParent();
    }

    @Override
    public PackageItems intern() {
        this.models.intern();
        this.datasourceSignons.intern();
        return (PackageItems)super.intern();
    }

    @Override
    public void handleRemovalFromCache() {
        super.handleRemovalFromCache();
        this.models.handleRemovalFromCache();
        this.datasourceSignons.handleRemovalFromCache();
    }

    public boolean hasDatasource(String datasourceSearchPath) {
        return this.datasourceSignons.getDatasourceSignon(datasourceSearchPath) != null;
    }

    public void importPackageDataFromTheCache(PackageItems packageItemsFromTheCache) {
        if (this.hasNoPackageItems()) {
            this.importItemsFromTheCache(packageItemsFromTheCache);
        }
        this.datasourceSignons.importDatasourceSignonsFromTheCache(packageItemsFromTheCache.datasourceSignons);
        if (this.models.isEmpty()) {
            this.models.importModelsFromTheCache(packageItemsFromTheCache.models);
        }
        this.importPreviousCacheValidator(packageItemsFromTheCache);
    }

    private boolean hasNoPackageItems() {
        return this.isEmpty();
    }

    private void importPreviousCacheValidator(PackageItems olderPackageItems) {
        if (this.hasNoCacheValidator()) {
            super.setCacheValidator(olderPackageItems.getCacheValidator());
        }
    }

    public void importPackageDataFromCM(PackageItems packageItemsFromCM) {
        this.datasourceSignons.importDatasourceSignonsFromCM(packageItemsFromCM.datasourceSignons);
    }

    @Override
    protected void addResponseAttributes(StringBuilder sb, QueryRequest queryRequest) {
        super.addResponseAttributes(sb, queryRequest);
        this.addSearchPathAttribute(sb, queryRequest);
    }

    private void addSearchPathAttribute(StringBuilder sb, QueryRequest queryRequest) {
        sb.append(" searchPath=\"").append(this.getXmlEncodedPackageName()).append("\"");
    }

    private String getXmlEncodedPackageName() {
        return XmlUtils.xmlEncode(this.getPackageName());
    }

    @Override
    protected void addShortRepliesElement(RemoteDispatcherResponse response, QueryRequest queryRequest) {
    }

    @Override
    protected void addFullRepliesElement(RemoteDispatcherResponse response, QueryRequest queryRequest) {
        List<String> allPackageItems = this.getAllPackageItems();
        response.addResponseLine(SoapTokens.getStartReplies(allPackageItems.size()));
        this.addItems(response, allPackageItems);
        response.addResponseLine(SoapTokens.getEndReplies());
    }

    private List<String> getAllPackageItems() {
        ArrayList<String> allPackageItems = new ArrayList<String>();
        allPackageItems.addAll(this.models.getAllItems());
        allPackageItems.addAll(this.getAllItemValues());
        allPackageItems.addAll(this.datasourceSignons.getAllItems());
        return allPackageItems;
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        super.dump(log, indent);
        indent = indent + "   ";
        this.models.dump(log, indent);
        this.datasourceSignons.dump(log, indent);
    }
}

