/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.QueryCacheElement;
import com.cognos.pogo.contentmanager.cache.QueryResult;
import com.cognos.pogo.contentmanager.cache.ResponseToClient;
import com.cognos.pogo.contentmanager.cache.SearchParameters;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import java.util.List;

public class QueryResponse
extends ResponseToClient {
    private final QueryCacheElement queryCacheElement;
    private final SearchParameters searchParameters;
    private final List<String> items;

    public QueryResponse(QueryCacheElement queryCacheElement, CachedResponse cachedResponse, SearchParameters searchParameters) {
        super(cachedResponse);
        this.queryCacheElement = queryCacheElement;
        this.searchParameters = searchParameters;
        this.items = queryCacheElement.getItems();
    }

    @Override
    protected void addSoapBodyContents() {
        this.addQueryResponse();
    }

    private void addQueryResponse() {
        this.startQueryResponse();
        this.addQueryResults();
        if (this.requestHasNoCacheContext()) {
            this.addCacheContext();
        }
        this.endQueryResponse();
    }

    private void startQueryResponse() {
        this.addResponseLine(SoapTokens.getStartQueryCacheResult());
        this.addResponseLine(SoapTokens.getStartResult());
    }

    private void addQueryResults() {
        QueryResult availableResults = this.getAvailableResults();
        this.addResponseLine(SoapTokens.getStartObjects(availableResults.getNrOfElements()));
        this.addResponseLines(availableResults.getStrings());
        this.addResponseLine(SoapTokens.getEndObjects());
    }

    private QueryResult getAvailableResults() {
        QueryResult results = new QueryResult();
        for (String item : this.items) {
            this.addQueryResultIfAvailable(item, results);
        }
        return results;
    }

    private void addQueryResultIfAvailable(String item, QueryResult results) {
        QueryResult result = this.getCachedResponse().getQueryResultFor(item, this.searchParameters);
        results.add(result);
    }

    private boolean requestHasNoCacheContext() {
        return this.queryCacheElement.hasNoCacheContext();
    }

    private void addCacheContext() {
        this.addResponseLine(SoapTokens.getStartCacheContext());
        this.addResponseLine(this.getCachedResponse().getCacheContext(this.searchParameters));
        this.addResponseLine(SoapTokens.getEndCacheContext());
    }

    private void endQueryResponse() {
        this.addResponseLine(SoapTokens.getEndResult());
        this.addResponseLine(SoapTokens.getEndQueryCacheResult());
    }
}

