/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CacheCleaner;
import com.cognos.pogo.contentmanager.cache.CacheContainer;
import com.cognos.pogo.contentmanager.cache.CacheElement;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.util.PogoLogger;
import java.util.Arrays;
import org.apache.log.Priority;

public class ResponseCacheCleaner
implements CacheCleaner {
    private static PogoLogger log = PogoLogger.getLogger();
    private ResponseCache responseCache;
    private int percentToCleanup;

    @Override
    public void cleanupCache(int percentToCleanup, ResponseCache responseCache) {
        this.percentToCleanup = percentToCleanup;
        this.responseCache = responseCache;
        this.cleanupCacheContainers();
    }

    private void cleanupCacheContainers() {
        CacheElement.disableAccessTimeUpdates();
        Object[] cacheContainers = this.responseCache.getAllCacheContainers().toArray();
        this.sortContainers(cacheContainers);
        this.removeOlderContainers(cacheContainers);
        CacheElement.enableAccessTimeUpdates();
    }

    private void sortContainers(Object[] cacheContainers) {
        this.logCacheContainers(cacheContainers, "Unsorted");
        Arrays.sort(cacheContainers);
        this.logCacheContainers(cacheContainers, "Sorted");
    }

    private void logCacheContainers(Object[] cacheContainers, String sortStatus) {
        if (log.isDebugEnabled()) {
            log.debug(sortStatus, " containers (last access time, description)");
            for (Object object : cacheContainers) {
                CacheContainer container = (CacheContainer)object;
                log.debug("   ", container.getLastAccessTime(), ", ", container);
            }
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    private void removeOlderContainers(Object[] cacheContainers) {
        long totalSize = cacheContainers.length;
        long sizeTarget = totalSize * (long)(100 - this.percentToCleanup) / 100L;
        for (Object object : cacheContainers) {
            CacheContainer container = (CacheContainer)object;
            if (totalSize <= sizeTarget) {
                return;
            }
            if (!container.isChildContainer() || !container.isEmpty()) continue;
            totalSize -= this.removeContainerAndItsChildren(container);
        }
    }

    private long removeContainerAndItsChildren(CacheContainer container) {
        long totalRemoved = container.getTotalNumberOfContainers();
        container.leaveCache();
        log.debug(container, " removed from cache. Total containers removed: ", totalRemoved);
        return totalRemoved;
    }
}

