/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CMCachePerfLoggerFactory;
import com.cognos.pogo.contentmanager.cache.ResponseCache;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PerfTimer;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;

public class ResponseCacheCleanupThread
extends SafeThread {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String THREAD_NAME = ResponseCacheCleanupThread.class.getSimpleName();
    private static final int MINIMUM_INTERVAL_BETWEEN_CLEANUPS_IN_MILLIS = 20000;
    private final ResponseCache responseCache;
    private final int percentToCleanup;
    private PerfLogger perfLogger = CMCachePerfLoggerFactory.createPerfLogger(this.getClass());

    public ResponseCacheCleanupThread(ResponseCache responseCache, int percentToCleanup) {
        super(THREAD_NAME);
        this.responseCache = responseCache;
        this.percentToCleanup = percentToCleanup;
    }

    @Override
    public void safeRun() {
        log.debug("Started cleanup thread");
        PerfTimer timer = null;
        if (this.perfLogger.isPerfLevelEnabled(PerfLogger.Level.LEVEL3)) {
            timer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL3, "run", "Number of accounts: ", this.responseCache.getNumberOfAccounts(), " Number of Packages: ", this.responseCache.getNumberOfPackages(), " Number of Reports: ", this.responseCache.getNumberOfReports());
        }
        this.responseCache.cleanupCache(this.percentToCleanup);
        this.perfLogger.stopTimer(timer);
        log.debug("Cleanup thread completed");
        this.resetCacheAlarm();
    }

    private void resetCacheAlarm() {
        this.pauseToPreventMultipleAlarms();
        ResponseCache.getStringPool().resetAlarm();
    }

    private void pauseToPreventMultipleAlarms() {
        try {
            ResponseCacheCleanupThread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

