/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.FaultStreamReaderDelegate;
import com.cognos.pogo.contentmanager.cache.ResponseHandler;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.StreamFactory;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ResponseFaultHandler
extends ResponseHandler {
    public ResponseFaultHandler(CachedResponse cachedResponse) {
        super(cachedResponse);
    }

    @Override
    public void handle(XMLStreamReader reader) throws XMLStreamException {
        FaultStreamReaderDelegate faultReader = new FaultStreamReaderDelegate(reader);
        this.saveFaultElement(faultReader);
        this.saveFaultErrorCode(faultReader);
    }

    private void saveFaultElement(XMLStreamReader reader) throws XMLStreamException {
        StringWriter faultWriter = StreamFactory.createStringWriter();
        XMLStreamWriter xmlWriter = XMLStreamFactory.createXMLStreamWriter(faultWriter);
        StaxUtils.moveToElement("Fault", reader);
        StaxUtils.copyCurrentElement(reader, xmlWriter);
        this.getCachedResponse().setFault(faultWriter.toString());
    }

    private void saveFaultErrorCode(FaultStreamReaderDelegate faultReader) {
        String errorCode = faultReader.getErrorCode();
        this.getCachedResponse().setFaultErrorCode(errorCode);
    }
}

