/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.SearchType;
import com.cognos.pogo.util.PogoLogger;

public class SearchParameters {
    private SearchType searchType;
    private String objectPath;

    public SearchParameters(SearchType searchType, String searchPath) {
        this.searchType = searchType != null ? searchType : SearchType.NULL;
        this.objectPath = searchPath != null ? searchPath : "";
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public boolean isSearchingForReport() {
        return this.searchType == SearchType.REPORT;
    }

    public boolean isSearchingForPackage() {
        return this.searchType == SearchType.PACKAGE;
    }

    public boolean isSearchingForModel() {
        return this.searchType == SearchType.MODEL;
    }

    public boolean isSearchingForDatasourceSignon() {
        return this.searchType == SearchType.DATASOURCESIGNON;
    }

    public boolean isSearchingForAccount() {
        return this.searchType == SearchType.ACCOUNT;
    }

    public boolean isSatisfiedBy(CachedResponse cachedResponse) {
        return cachedResponse != null && this.satisfiesSearch(cachedResponse);
    }

    private boolean satisfiesSearch(CachedResponse cachedResponse) {
        return this.satisfiesReportSearch(cachedResponse) || this.satisfiesPackageSearch(cachedResponse) || this.satisfiesModelSearch(cachedResponse) || this.satisfiesDatasourceSearch(cachedResponse) || this.satisfiesAccountSearch(cachedResponse);
    }

    private boolean satisfiesReportSearch(CachedResponse cachedResponse) {
        return this.isSearchingForReport() && cachedResponse.hasReportItemsFor(this.objectPath);
    }

    private boolean satisfiesPackageSearch(CachedResponse cachedResponse) {
        return this.isSearchingForPackage() && cachedResponse.hasPackageItemsFor(this.objectPath);
    }

    private boolean satisfiesModelSearch(CachedResponse cachedResponse) {
        return this.isSearchingForModel() && cachedResponse.getModel(this.objectPath) != null;
    }

    private boolean satisfiesDatasourceSearch(CachedResponse cachedResponse) {
        return this.isSearchingForDatasourceSignon() && cachedResponse.hasDatasource(this.objectPath);
    }

    private boolean satisfiesAccountSearch(CachedResponse cachedResponse) {
        return this.isSearchingForAccount() && cachedResponse.hasAccountItems();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(searchType: " + (Object)((Object)this.searchType) + ", objectPath: " + this.objectPath + ')';
    }

    public void dump(PogoLogger log, String indent) {
        log.debug(indent, this, ": ");
        indent = indent + "   ";
        log.debug(new Object[]{indent, "searchType: ", this.searchType});
        log.debug(indent, "objectPath: ", this.objectPath);
    }
}

