/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.cache.remote;

import com.cognos.pogo.contentmanager.cache.CachedResponse;
import com.cognos.pogo.contentmanager.cache.ResponseItems;
import com.cognos.pogo.contentmanager.cache.ResponseToClient;
import com.cognos.pogo.contentmanager.cache.SoapTokens;
import com.cognos.pogo.contentmanager.cache.level2.QueryRequest;
import com.cognos.pogo.contentmanager.cache.remote.RemoteDispatcherRequest;

public class RemoteDispatcherResponse
extends ResponseToClient {
    private final RemoteDispatcherRequest remoteDispatcherRequest;

    public RemoteDispatcherResponse(RemoteDispatcherRequest remoteDispatcherRequest, CachedResponse responseFromCache) {
        super(responseFromCache);
        remoteDispatcherRequest.addMissingSearchPaths(responseFromCache);
        this.remoteDispatcherRequest = remoteDispatcherRequest;
    }

    @Override
    protected void addSoapBodyContents() {
        this.addCustomResponse();
    }

    private void addCustomResponse() {
        this.startCustomResponse();
        this.addResponses();
        this.endCustomResponse();
    }

    private void startCustomResponse() {
        this.addResponseLine(SoapTokens.getStartCustomResponse());
    }

    private void addResponses() {
        for (QueryRequest queryRequest : this.remoteDispatcherRequest.getQueryRequests()) {
            this.addResponseFor(queryRequest);
        }
    }

    private void addResponseFor(QueryRequest queryRequest) {
        ResponseItems responseItems = this.getCachedResponse().getResponseItemsFor(queryRequest.getName(), queryRequest.getSearchPath());
        if (responseItems != null) {
            responseItems.addToRemoteDispatcherResponse(this, queryRequest);
        }
    }

    private void endCustomResponse() {
        this.addResponseLine(SoapTokens.getEndCustomResponse());
    }
}

