/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerGetActiveCommand;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import java.util.List;

public class ActiveCmFinder {
    private static final PogoLogger log = PogoLogger.getLogger();
    private List<NodeID> cmList;
    private String foundCM;
    private int started = 0;
    private long DEFAULT_TIMEOUT = 30000L;
    private static final String ACTIVE_C_M_FINDER_TIMEOUT = "ActiveCMFinderTimeout";
    private ThreadGroup findThreadGroup;
    private long timeout = this.getTimeout();

    public String findActiveCM() {
        this.findThreadGroup = new ThreadGroup("findingActiveCmThreadGroup");
        this.cmList = NodeIdGuidMapper.getInstance().getCmUrlList();
        for (NodeID cmNode : this.cmList) {
            SingleFindCM singleFindCM = new SingleFindCM(this.findThreadGroup, cmNode);
            ++this.started;
            singleFindCM.start();
        }
        log.debug("about to wait for active CM");
        return this.timedGet(this.timeout);
    }

    private long getTimeout() {
        String timeoutStr = PropertyInserter.getProperty(ACTIVE_C_M_FINDER_TIMEOUT);
        if (timeoutStr != null) {
            try {
                return Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException e) {
                log.info("unable to parse ", ACTIVE_C_M_FINDER_TIMEOUT, " ", timeoutStr);
            }
        }
        return this.DEFAULT_TIMEOUT;
    }

    private synchronized String timedGet(long msecs) {
        long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = msecs;
        while (this.started > 0) {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                log.debug("Interrupt in active cm finder wait", e);
            }
            if (this.foundCM != null) {
                log.debug("Done waiting, found active CM");
                return this.foundCM;
            }
            waitTime = msecs - (System.currentTimeMillis() - startTime);
            log.debug("Done waiting, no active CM found. wait time left = ", waitTime, " started = ", this.started);
            if (waitTime > 0L) continue;
            return null;
        }
        return null;
    }

    private synchronized void setFoundCMUri(String newURI) {
        this.foundCM = newURI;
        this.notifyAll();
    }

    private synchronized void stopped() {
        --this.started;
        this.notifyAll();
    }

    private class SingleFindCM
    extends SafeThread {
        private NodeID cmNodeId;

        SingleFindCM(ThreadGroup threadGroup, NodeID cmNodeId) {
            super(threadGroup, "findingActiveCmThread");
            this.cmNodeId = cmNodeId;
        }

        @Override
        public void safeRun() {
            log.info("getting active CM from ", this.cmNodeId);
            ContentManagerGetActiveCommand command = new ContentManagerGetActiveCommand(this.cmNodeId);
            command.setDoTrustedRequest(true);
            try {
                command.execute();
                String newActiveCM = command.getActiveCM();
                log.info("got active cm ", newActiveCM, " from ", this.cmNodeId.getURI());
                ActiveCmFinder.this.setFoundCMUri(newActiveCM);
                this.cmNodeId.setCmStatus("OK");
            }
            catch (CommandExecutionException e) {
                String errorcode = command.getErrorCode();
                this.cmNodeId.setCmStatus(errorcode);
                log.debug("Trouble communicating with " + this.cmNodeId.getURI() + ", error = " + errorcode, e);
                ActiveCmFinder.this.stopped();
            }
        }
    }
}

