/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.contentmanager.PogoConnectionFactory;
import com.cognos.pogo.util.PogoLogger;

public class CMUri {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private boolean forceCMChanged;

    boolean checkActiveCMChanged(String activecm) {
        NodeID oldCmNode = NodeIdGuidMapper.getContentManagerNID();
        NodeID newCmNode = NodeID.getNodeID(activecm);
        if (newCmNode.isLocalToSelf()) {
            newCmNode = this.setCmUriToInternal(newCmNode);
        }
        cat.debug("Checking if CM has changed old = ", oldCmNode, " new = ", newCmNode);
        if (oldCmNode == null || !newCmNode.isTheSameAs(oldCmNode)) {
            this.initCMUrl(newCmNode);
            return this.cmHasChanged(true);
        }
        return this.cmHasChanged(false);
    }

    private boolean cmHasChanged(boolean changed) {
        boolean oldForced = this.forceCMChanged;
        this.forceCMChanged = false;
        return changed ? true : oldForced;
    }

    private void initCMUrl(NodeID cmNode) {
        NodeIdGuidMapper.setContentManagerNID(cmNode);
        cat.info("Using content manager: ", NodeIdGuidMapper.getContentManagerNID().toString(), " AKA ", NodeIdGuidMapper.getContentManagerNID().toInetString());
        this.destroyCMConnectionPool();
    }

    private void destroyCMConnectionPool() {
        PogoConnectionFactory.getInstance().destroyCMConnectionPool();
    }

    private NodeID setCmUriToInternal(NodeID cmNode) {
        String protocol = PropertyInserter.getProperty("internalDispatcher.protocol");
        String host = PropertyInserter.getProperty("internalDispatcher.host");
        String port = PropertyInserter.getProperty("internalDispatcher.port");
        StringBuffer newURI = new StringBuffer();
        newURI.append(protocol).append("://").append(host).append(":").append(port);
        newURI.append(cmNode.getPath());
        NodeID newCmNode = NodeID.getNodeID(newURI.toString());
        cat.debug("Changing CM URL from ", cmNode, " to ", newCmNode);
        return newCmNode;
    }

    public static boolean isActiveCMLocal() {
        NodeID cmNode = NodeIdGuidMapper.getContentManagerNID();
        return cmNode != null && cmNode.isLocalToSelf();
    }

    public void resetCMChanged() {
        this.forceCMChanged = true;
    }
}

