/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.contentmanager.ContentManagerConfigurationCommand;
import com.cognos.pogo.contentmanager.coordinator.CMUtils;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.ServiceErrorAuditMsg;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.DispatcherServices;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConfigurationCMQuery {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ConfigurationCMQuery.class.getName());
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    static final Slogger slogger = loggingRealm.getLogger(ConfigurationCMQuery.class.getName());
    private final String dispatcherName;
    private Date lastModificationTime = new Date(0L);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private boolean noDispatcher;
    protected DispatcherServices dispatcherServices;
    private ArrayList<String> globalParameters;
    protected ArrayList<String> invalidAttributeList;

    public ConfigurationCMQuery(PogoEngine pogoEngine, String dispatcherName) {
        this.dispatcherServices = pogoEngine.getDispatcherServices();
        this.dispatcherName = dispatcherName;
        this.globalParameters = this.dispatcherServices.getGlobalAttributeList();
        this.invalidAttributeList = new ArrayList();
    }

    boolean queryCM(ConfigurationImpl configuration) throws Exception {
        ContentManagerConfigurationCommand cmd = null;
        cmd = this.runQueryCommand(configuration);
        this.setLastModificationTime(cmd.getLastModificationTime());
        if (configuration.isLocalDispatcherAvailable()) {
            this.setNoDispatcher(false);
        } else {
            this.setNoDispatcher(true);
            configuration.setForceUpdateRunningStateOnReconfigure(true);
        }
        return !this.isNoDispatcher();
    }

    ContentManagerConfigurationCommand runQueryCommand(ConfigurationImpl configuration) throws CommandExecutionException, SoapFaultException {
        CommandInvalidAttribute commandInvalidAttribute = this.runCommandCheckForInvalidAttribute(configuration);
        while (commandInvalidAttribute.invalidAttribute != null) {
            commandInvalidAttribute = this.runCommandCheckForInvalidAttribute(configuration);
        }
        return commandInvalidAttribute.command;
    }

    private void setLastModificationTime(String lastModificationTime) {
        try {
            this.lastModificationTime = dateFormat.parse(lastModificationTime);
        }
        catch (ParseException ex) {
            cat.error("unable to parse lastModificationTime from CM", (Throwable)ex);
        }
    }

    protected CommandInvalidAttribute runCommandCheckForInvalidAttribute(ConfigurationImpl configuration) throws SoapFaultException, CommandExecutionException {
        ContentManagerConfigurationCommand cmd = this.createContentManagerQueryCommand(configuration);
        this.initializeCommand(cmd);
        String invalidAttribute = this.executeCheckForInvalidAttribute(cmd);
        if (invalidAttribute != null) {
            this.globalParameters.remove(invalidAttribute);
            this.invalidAttributeList.add(invalidAttribute);
            cat.error("Invalid service attribute detected( " + invalidAttribute + ") Service definition file corrupted.");
        }
        return new CommandInvalidAttribute(cmd, invalidAttribute);
    }

    protected ArrayList<String> getValidDispatcherServicesAttributeList() {
        ArrayList<String> attributeList = new ArrayList<String>();
        for (String attr : this.dispatcherServices.getAttributeList()) {
            if (this.invalidAttributeList.contains(attr)) continue;
            attributeList.add(attr);
        }
        return attributeList;
    }

    private void initializeCommand(ContentManagerConfigurationCommand cmd) {
        for (String attr : this.getValidDispatcherServicesAttributeList()) {
            cmd.addQueryPropertyName(attr);
        }
        cmd.setDoTrustedRequest(true);
        if (cat.isDebugEnabled()) {
            cat.debug("Using " + this.lastModificationTime + " for userCapability configuration query");
        }
        cmd.setLastModificationTime(dateFormat.format(this.lastModificationTime));
    }

    String executeCheckForInvalidAttribute(BIBusCommand command) throws CommandExecutionException, SoapFaultException {
        try {
            command.execute();
        }
        catch (SoapFaultException sfe) {
            try {
                return CMUtils.getInvalidService(sfe);
            }
            catch (SoapFaultException e) {
                this.logServiceError(e);
                throw e;
            }
        }
        return null;
    }

    private void logServiceError(SoapFaultException e) {
        ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg("Dispatcher", "configure");
        msg.addErrorMessage(e);
        msg.addErrorMessage(e.getDetail());
        slogger.log(msg);
    }

    ContentManagerConfigurationCommand createContentManagerQueryCommand(ConfigurationImpl configuration) {
        StringBuffer query = this.createSearchPath();
        ContentManagerConfigurationCommand cmd = new ContentManagerConfigurationCommand(query.toString(), this.dispatcherName, configuration, this.globalParameters);
        return cmd;
    }

    private StringBuffer createSearchPath() {
        StringBuffer query = new StringBuffer("/configuration/descendant::dispatcher[@dispatcherPath=\"");
        query.append(this.dispatcherName);
        query.append("\"]");
        query.append("/*[");
        String seperator = "";
        for (Service service : this.dispatcherServices.getBootstrapServices()) {
            query.append(seperator);
            query.append("@objectClass=\"");
            query.append(service.getName());
            query.append("\"");
            seperator = " or ";
        }
        query.append("]");
        return query;
    }

    public boolean checkTime(String newTime) {
        try {
            Date newDate = dateFormat.parse(newTime);
            if (cat.isDebugEnabled()) {
                cat.debug("Checking to see if configuration has changed");
                cat.debug("old lastModificationTime = " + this.lastModificationTime + ", new lastModificationTime = " + newDate);
            }
            if (newDate.after(this.lastModificationTime)) {
                return true;
            }
        }
        catch (ParseException e) {
            cat.error("unable to parse lastModificationTime from CM", (Throwable)e);
        }
        return false;
    }

    void setNoDispatcher(boolean noDispatcher) {
        this.noDispatcher = noDispatcher;
    }

    public boolean isNoDispatcher() {
        return this.noDispatcher;
    }

    public ArrayList<String> getGlobalParameters() {
        return this.globalParameters;
    }

    public class CommandInvalidAttribute {
        public ContentManagerConfigurationCommand command;
        public String invalidAttribute;

        public CommandInvalidAttribute(ContentManagerConfigurationCommand command, String invalidAttribute) {
            this.command = command;
            this.invalidAttribute = invalidAttribute;
        }
    }
}

