/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerAddCommand;
import com.cognos.pogo.contentmanager.ContentManagerDeleteCommand;
import com.cognos.pogo.contentmanager.ContentManagerUpdateCommand;
import com.cognos.pogo.contentmanager.coordinator.CMUtils;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.util.PogoLogger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class ServiceSynchronizer {
    static final PogoLogger cat = PogoLogger.getLogger();
    private Map<String, Service> servicesToAdd;
    private Set<String> servicesToRemove = new HashSet<String>();
    private Set<Service> servicesUpdateSet = new HashSet<Service>();
    private Set<String> installedComponentsToAdd;
    private Set<String> installedComponentsToRemove = new HashSet<String>();
    private List<CMClass> classList;

    ServiceSynchronizer(Map<String, Service> servicesFromFile, Set<String> installedComponents, List<CMClass> cmClassList) {
        this.servicesToAdd = servicesFromFile;
        this.installedComponentsToAdd = new HashSet<String>(installedComponents);
        this.classList = cmClassList;
        this.synchronize();
    }

    protected void synchronize() {
        for (CMClass service : this.classList) {
            String serviceClass = ((Element)service.getItemElement().selectSingleNode("objectClass/value")).getTextTrim();
            if ("installedComponent".equals(serviceClass)) {
                String componentID = ((Element)service.getItemElement().selectSingleNode("componentID/value")).getTextTrim();
                if (this.installedComponentsToAdd.contains(componentID)) {
                    cat.info("Not overwriting installComponent object ", componentID);
                    this.installedComponentsToAdd.remove(componentID);
                    continue;
                }
                this.installedComponentsToRemove.add(componentID);
                continue;
            }
            if (!(this.servicesToAdd.containsKey(serviceClass) || serviceClass.endsWith("runTimeState") || serviceClass.endsWith("systemMetricThresholds"))) {
                this.servicesToRemove.add(serviceClass);
                continue;
            }
            if (!this.servicesToAdd.containsKey(serviceClass)) continue;
            cat.info("Not overwriting service object ", serviceClass);
            Service aService = this.servicesToAdd.remove(serviceClass);
            if (!aService.isForceCMDefaultName()) continue;
            this.servicesUpdateSet.add(aService);
        }
    }

    void removeStaleServicesFromCM(String dispatcherPath) throws CommandExecutionException {
        Iterator<String> installedComponentsIterator = this.installedComponentsToRemove.iterator();
        Iterator<String> servicesIterator = this.servicesToRemove.iterator();
        if (!installedComponentsIterator.hasNext() && !servicesIterator.hasNext()) {
            return;
        }
        ContentManagerDeleteCommand delete = new ContentManagerDeleteCommand();
        while (installedComponentsIterator.hasNext()) {
            delete.addObject("installedComponent");
            String componentID = installedComponentsIterator.next();
            cat.info("Removing stale installedComponent of type: ", componentID);
            StringBuffer strBuf = new StringBuffer(dispatcherPath);
            strBuf.append("/installedComponent[@defaultName='installedComponent");
            strBuf.append(componentID);
            strBuf.append("']");
            delete.setSearchPath(strBuf.toString());
        }
        while (servicesIterator.hasNext()) {
            String serviceName = servicesIterator.next();
            cat.info("Removing stale object of type: ", serviceName);
            delete.addObject(serviceName);
            delete.setSearchPath(dispatcherPath + "/" + serviceName);
        }
        delete.setForce(true);
        delete.setRecursive(true);
        delete.setDoTrustedRequest(true);
        delete.execute();
    }

    void addServicesAndInstalledComponents(String dispatcherPath) throws CommandExecutionException {
        String invalidService = this.addServicesFromSet(dispatcherPath, this.servicesToAdd);
        while (invalidService != null) {
            cat.error("The following service is invalid and will not be registered in CM: ", invalidService);
            this.servicesToAdd.remove(invalidService);
            this.installedComponentsToAdd.remove(invalidService);
            invalidService = this.addServicesFromSet(dispatcherPath, this.servicesToAdd);
        }
    }

    String addServicesFromSet(String dispatcherPath, Map<String, Service> services) throws CommandExecutionException, SoapFaultException {
        if (services.isEmpty() && this.installedComponentsToAdd.isEmpty()) {
            return null;
        }
        ContentManagerAddCommand addCmd = this.createAddCommand();
        addCmd.setSearch(dispatcherPath);
        for (Service service : services.values()) {
            addCmd.addObject(service.getName());
            addCmd.setDefaultName(service.getCMdefaultName());
            cat.info("Adding service object ", service.getName());
        }
        for (String componentName : this.installedComponentsToAdd) {
            addCmd.addObject("installedComponent");
            addCmd.setDefaultName("installedComponent" + componentName);
            addCmd.setComponentID(componentName);
            cat.info("Adding installedComponent object ", componentName);
        }
        addCmd.setDoTrustedRequest(true);
        try {
            addCmd.execute();
        }
        catch (SoapFaultException e) {
            return CMUtils.getInvalidService(e);
        }
        addCmd.getAddResponse();
        return null;
    }

    protected ContentManagerAddCommand createAddCommand() {
        return new ContentManagerAddCommand();
    }

    void updateCMDefaultNames(String dispatcherPath) throws CommandExecutionException {
        if (this.servicesUpdateSet.isEmpty()) {
            return;
        }
        ContentManagerUpdateCommand updateCmd = new ContentManagerUpdateCommand();
        for (Service service : this.servicesUpdateSet) {
            String serviceClass = service.getName();
            String serviceDefaultName = service.getCMdefaultName();
            updateCmd.addObject(serviceClass);
            updateCmd.setSearchPath(dispatcherPath + "/" + serviceClass);
            updateCmd.setDefaultName(serviceDefaultName);
            cat.info("Forcing defaultName of '", serviceDefaultName, "' for service object ", serviceClass);
        }
        updateCmd.setDoTrustedRequest(true);
        updateCmd.execute();
    }
}

