/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.dropin;

import com.cognos.pogo.dropin.DropinFolderMonitor;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import org.dom4j.Element;

public class DropinFolderMonitorHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String DIRECTORY_ATTRIBUTE = "directory";
    protected String directory;
    private DropinFolderMonitor dropinFolderMonitor;
    private long scanTime = 5000L;

    public DropinFolderMonitorHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.directory = this.getAttribute(log, DIRECTORY_ATTRIBUTE);
        this.scanTime = this.getLongAttribute("scanTime", this.scanTime);
    }

    private long getLongAttribute(String attrName, long defaultValue) {
        String attribute = this.getOptionalAttribute(attrName);
        if (attribute == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(attribute);
        }
        catch (NumberFormatException e) {
            log.debug("Invalid format for attribute ", attrName, ": ", attribute);
            return defaultValue;
        }
    }

    @Override
    public void start() {
        this.dropinFolderMonitor = this.createDropinFolderMonitor(this.directory);
        this.dropinFolderMonitor.setScanTime(this.scanTime);
        this.dropinFolderMonitor.watch();
    }

    protected DropinFolderMonitor createDropinFolderMonitor(String directory2) {
        return new DropinFolderMonitor(directory2);
    }

    @Override
    public void stop() {
        this.dropinFolderMonitor.stop();
    }

    String getDirectory() {
        return this.directory;
    }

    long getScanTime() {
        return this.scanTime;
    }
}

