/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager;

import com.cognos.pogo.auth.Passport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.transport.FormRequestProcessor;
import org.dom4j.Element;
import org.dom4j.QName;

abstract class GetDataProcessor {
    private static QName QUERY_QNAME = new QName("query", BIBusEnvelope.NS_BUS);
    private static QName PROPENUM_QNAME = new QName("propEnum", BIBusEnvelope.NS_BUS);
    private static QName QUERY_OPTIONS_QNAME = new QName("queryOptions", BIBusEnvelope.NS_BUS);
    protected String pathInfo;
    protected MessageContext mc;

    abstract String getSearchPath();

    abstract String getPassportID();

    GetDataProcessor(String newPathInfo, MessageContext messageContext) {
        this.pathInfo = newPathInfo;
        this.mc = messageContext;
    }

    public BIBusEnvelope constructCMRequest(PerformanceEventListener performanceIndicator) {
        String fullSearchPath = this.getSearchPath();
        if (fullSearchPath == null) {
            return null;
        }
        if (this.forceHTMLErrorPage(fullSearchPath)) {
            this.mc.setProperty("SMEMOutput", Boolean.TRUE);
        }
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)this.mc.getProperty("request.envelope");
        Element bodyElement = requestEnvelope.getBody();
        Element queryElement = bodyElement.addElement(QUERY_QNAME);
        Element searchElement = queryElement.addElement("search");
        searchElement.setText(fullSearchPath);
        performanceIndicator.handleObjectPath(fullSearchPath);
        Element propertiesElement = queryElement.addElement("properties");
        requestEnvelope.addRequiredEnvNamespaces(propertiesElement);
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        propertiesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, PROPENUM_QNAME.getQualifiedName());
        Element itemElement = propertiesElement.addElement("item");
        itemElement.setText("data");
        Element queryOptionsElement = queryElement.addElement("options");
        queryOptionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, QUERY_OPTIONS_QNAME.getQualifiedName());
        Element dataEncoding = queryOptionsElement.addElement("dataEncoding");
        dataEncoding.setText("MIME");
        FormRequestProcessor.addValidator(requestEnvelope, this.mc);
        String passportID = this.getPassportID();
        if (passportID != null) {
            this.copyPassportIdToEnvelope(passportID, requestEnvelope);
        }
        return requestEnvelope;
    }

    private void copyPassportIdToEnvelope(String passportID, BIBusEnvelope requestEnvelope) {
        requestEnvelope.createCamPassportElement(passportID);
        requestEnvelope.setFormField("m_passportID", passportID);
        Passport passport = requestEnvelope.getPassport();
        passport.processPassport();
    }

    private boolean forceHTMLErrorPage(String searchPath) {
        if (searchPath.startsWith("defaultOutput") || searchPath.startsWith("URLID") || searchPath.startsWith("storeID")) {
            return true;
        }
        int lastSlashPosition = searchPath.lastIndexOf(47);
        return searchPath.startsWith("output", lastSlashPosition + 1);
    }

    static void makeDummyResponse(MessageContext mc) {
        mc.setResponseName("response");
        mc.setProperty("response.envelope", new BIBusEnvelope());
    }
}

