/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DelayHandler
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DelayHandler.class.getName());

    public DelayHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        ByteArrayOutputStream baosXML = new ByteArrayOutputStream();
        try {
            BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
            String delay = env.getFormValue("delay");
            PrintWriter pw = new PrintWriter(baosXML);
            if (delay != null) {
                pw.println("Sleep time was: " + delay);
                try {
                    long delaySec = Long.parseLong(delay);
                    Thread.sleep(delaySec * 1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pw.close();
            DelayHandler.prepareResponse(mc, "text/plain", baosXML.toByteArray());
        }
        catch (IOException x) {
            Fault f = new Fault("IOexception preparing response.", x);
            mc.setFault(f);
        }
    }

    @Override
    public void configure(Configuration configuration) {
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }
}

