/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class DumpXMLHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DumpXMLHandler.class.getName());
    String xml;
    String filename;

    public DumpXMLHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.xml = this.getRequiredAttribute(cat, "xml_name");
        this.filename = this.getRequiredAttribute(cat, "filename");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        Object o = this.xml.equals("mc.getFault()") ? mc.getFault() : mc.getProperty(this.xml);
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            XMLWriter xml_writer = new XMLWriter((OutputStream)fos);
            if (o instanceof Element) {
                xml_writer.write((Element)o);
            } else if (o instanceof Document) {
                xml_writer.write((Document)o);
            } else if (o instanceof SOAPEnvelope) {
                xml_writer.write(((SOAPEnvelope)o).getEnvelope());
            } else if (o instanceof Fault) {
                BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                xml_writer.write(((Fault)o).generateEnvelope(requestEnvelope).getEnvelope());
            }
            xml_writer.close();
        }
        catch (Exception x) {
            cat.debug("failed to log xml", (Throwable)x);
        }
    }
}

