/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.handlers.debug.JMeterRecordingHandler;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterRecordingController
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(JMeterRecordingController.class.getName());
    private JMeterRecordingHandler recordingHandler;
    String configuredFileName;
    String outputFilename;

    public JMeterRecordingController() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String sRecordingHandler = this.getRequiredAttribute(cat, "recordingHandler");
        Handler h = engine.lookupHandler(sRecordingHandler);
        if (h == null || !(h instanceof JMeterRecordingHandler)) {
            cat.error("Cannot resolve reference to JMeter recording handler named \"" + sRecordingHandler + "\"\nJMeter recording is disabled.");
        } else {
            this.recordingHandler = (JMeterRecordingHandler)h;
        }
        this.configuredFileName = this.getRequiredAttribute(cat, "outputFile");
        cat.debug("configured output file is: " + this.configuredFileName);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String sMessage = this.processRequest(mc);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.print(sMessage);
            pw.close();
            JMeterRecordingController.prepareResponse(mc, "text/html", baos.toByteArray());
        }
        catch (IOException x) {
            cat.error("Error while generating response page for jmeter action.  Response message was: " + sMessage, (Throwable)x);
        }
    }

    String processRequest(MessageContext mc) {
        if (this.recordingHandler == null) {
            return "JMeter recording is not configured correctly";
        }
        String soapAction = mc.getStrProperty("request.soapaction");
        if (soapAction.endsWith("Start")) {
            try {
                this.recordingHandler.startJMeterRecording(mc, this.outputFilename);
                return "Started recording to file :" + this.configuredFileName;
            }
            catch (IOException x) {
                cat.debug("Failed to start JMeter recording", (Throwable)x);
                return "Failed to start JMeter recording: " + x.getMessage();
            }
        }
        if (soapAction.endsWith("Stop")) {
            try {
                this.recordingHandler.stopJMeterRecording();
                return "JMeter recording has been stopped.";
            }
            catch (IOException x) {
                return "Failed to start JMeter recording: " + x.getMessage();
            }
        }
        return "to start recording: b_action=jmeterStart<br>to stop recording:  b_action=jmeterStop<br>";
    }

    @Override
    public void configure(Configuration configuration) {
        this.outputFilename = configuration.getICCLConfiguration().resolveEffectivePath(this.configuredFileName);
        cat.debug("Output file name was resolved to: " + this.outputFilename);
    }
}

