/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.ConversationContext;
import com.cognos.pogo.util.PogoLogger;

public class LogConversationContextHandler
extends BasicHandler {
    private static PogoLogger log = PogoLogger.getLogger();
    private String envelopeContextName;

    public LogConversationContextHandler() {
        super(log.getNativeLogger());
    }

    public LogConversationContextHandler(PogoLogger log) {
        super(log.getNativeLogger());
        LogConversationContextHandler.log = log;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.envelopeContextName = this.getAttribute(log, "envelopeContextName");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (log.isDebugEnabled()) {
            this.logConversationContext(mc);
        }
    }

    private void logConversationContext(MessageContext mc) {
        ConversationContext conversationContext = this.getConversationContext(mc);
        if (conversationContext == null || conversationContext.isEmpty()) {
            log.debug("no conversationContext in " + this.envelopeContextName);
        } else {
            log.debug(this.envelopeContextName + " has conversationContext:\n" + conversationContext.asXML());
        }
    }

    private ConversationContext getConversationContext(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty(this.envelopeContextName);
        return envelope != null ? envelope.getBiBusHeader().getTracking().getConversationContext() : null;
    }
}

